/**********************************************************************
 *<
	FILE: expgizmo.h

	DESCRIPTION: A gizmo helper for the explode atmospheric effect

	CREATED BY: Rolf Berteig

	HISTORY: 4-15-96

 *>	Copyright (c) 1996 Rolf Berteig, All Rights Reserved.
 **********************************************************************/

#ifndef __EXPGIZMO_H__
#define __EXPGIZMO_H__

#define EXPGIZMO_NAME		GetString(IDS_RB_COMBUSTION)
#define EXPGIZMO_CLASSID	Class_ID(0x3bc31904, 0x67d74ec7)

class ExpGizmoObject : public GizmoObject {
	public:
		static IParamMap *pmapParam;
		static IObjParam *ip;

		ExpGizmoObject();
		~ExpGizmoObject();

		// From BaseObject
		CreateMouseCallBack* GetCreateMouseCallBack();
		void BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev);
		void EndEditParams( IObjParam *ip, ULONG flags,Animatable *next);
		TCHAR *GetObjectName() { return EXPGIZMO_NAME; }
		void InitNodeName(TSTR& s) {s = EXPGIZMO_NAME;}

		// Animatable methods
		void DeleteThis() {delete this;}
		Class_ID ClassID() {return EXPGIZMO_CLASSID;}
		
		// From ref
		RefTargetHandle Clone(RemapDir& remap = NoRemap());		

		// From GizmoObject		
		void InvalidateUI();
		ParamDimension *GetParameterDim(int pbIndex);
		TSTR GetParameterName(int pbIndex);
		void DrawGizmo(TimeValue t,GraphicsWindow *gw);		
		void GetBoundBox(Matrix3 &mat,TimeValue t,Box3 &box);
	};

#define PB_GIZMO_RADIUS	0
#define PB_GIZMO_HEMI	1
#define PB_GIZMO_SEED	2


#endif //__EXPGIZMO_H__
