/**********************************************************************
 *<
	FILE: prim.cpp

	DESCRIPTION:   DLL implementation of primitives

	CREATED BY: Dan Silva

	HISTORY: created 12 December 1994

 *>	Copyright (c) 1994, All Rights Reserved.
 **********************************************************************/

#include "prim.h"
#include "3dsurfer.h"
#include "buildver.h"

HINSTANCE hInstance;
int controlsInit = FALSE;

/** public functions **/
BOOL WINAPI DllMain(HINSTANCE hinstDLL,ULONG fdwReason,LPVOID lpvReserved) {
	hInstance = hinstDLL;
	static call=0;

	if ( !controlsInit ) {
		controlsInit = TRUE;
		
		// jaguar controls
		InitCustomControls(hInstance);

#ifdef OLD3DCONTROLS
		// initialize 3D controls
		Ctl3dRegister(hinstDLL);
		Ctl3dAutoSubclass(hinstDLL);
#endif
		
		// initialize Chicago controls
		InitCommonControls();
		}


	switch(fdwReason) {
		case DLL_PROCESS_ATTACH:
			//MessageBox(NULL,_T("PRIM.DLL: DllMain)",_T("Prim"),MB_OK);
			break;
		case DLL_THREAD_ATTACH:
			break;
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
			break;
		}
	return(TRUE);
	}


//------------------------------------------------------
// This is the interface to Jaguar:
//------------------------------------------------------

__declspec( dllexport ) const TCHAR *
LibDescription() { return _T(" Surface Tool library "); }

#ifndef DESIGN_VER

/// MUST CHANGE THIS NUMBER WHEN ADD NEW CLASS
__declspec( dllexport ) int LibNumberClasses() {return 1;}


__declspec( dllexport ) ClassDesc*
LibClassDesc(int i) {
	switch(i) {
		case 0: return GetDonutDesc();
		default: return 0;
		}

	}

#else

//
// DESIGN VERSION EXCLUDES SOME PLUG_INS
//

/// MUST CHANGE THIS NUMBER WHEN ADD NEW CLASS
__declspec( dllexport ) int LibNumberClasses() {return 30;}


__declspec( dllexport ) ClassDesc*
LibClassDesc(int i) {
	switch(i) {
		case 0: return GetBoxobjDesc();
		case 1: return GetSphereDesc();
		case 2: return GetCylinderDesc();
		case 3: return GetLookatCamDesc();
		case 4: return GetOmniLightDesc();
		case 5: return GetSimpleCamDesc();
		case 6: return GetTargetObjDesc();
		case 7: return GetTSpotLightDesc();
		case 8: return GetDirLightDesc();
		case 9: return GetSplineDesc();
		case 10: return GetNGonDesc();
		case 11: return GetDonutDesc();
		//case 12: return GetBonesDesc();
		//case 13: return GetRingMasterDesc();
		//case 14: return GetSlaveControlDesc();
		case 12: return GetQuadPatchDesc();
		case 13: return GetTriPatchDesc();
		case 14: return GetTorusDesc();
		//case 18: return GetMorphObjDesc();
		//case 19: return GetCubicMorphContDesc();
		case 15: return GetFSpotLightDesc();
		case 16: return GetRectangleDesc();
		case 17: return GetBoolObjDesc();
		case 18: return GetTapeHelpDesc();
		case 19: return GetTubeDesc();
		case 20: return GetConeDesc();
		case 21: return GetHedraDesc();
		case 22: return GetCircleDesc();
		case 23: return GetEllipseDesc();
		case 24: return GetArcDesc();
		case 25: return GetStarDesc();
		case 26: return GetHelixDesc();
		case 27: return GetRainDesc();
		case 28: return GetSnowDesc();
		case 29: return GetTextDesc();
		//case 35: return GetTeapotDesc();
		default: return 0;
		}

	}

#endif



// Return version so can detect obsolete DLLs
__declspec( dllexport ) ULONG 
LibVersion() { return VERSION_3DSMAX; }

TCHAR *GetString(int id)
	{
	static TCHAR buf[256];

	if (hInstance)
		return LoadString(hInstance, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
	}
