/**********************************************************************
 *<
	FILE: edge to spline

	DESCRIPTION:  A utility that converts selected edges to splines

	CREATED BY: Peter Watje

	HISTORY: created Oct 15,1 996

 *>	Copyright (c) 1996, All Rights Reserved.
 **********************************************************************/

#include "util.h"
#include "utilapi.h"
#include "bmmlib.h"
#include "shape.h"
#include "spline3d.h"
#include "splshape.h"
#include "linshape.h"

#define ASCII_OUT_CLASS_ID		0x7e802a7b, 0x41df42e6

class EdgeType{

public:
	unsigned int a, b;
	int used;
	int connectedto;
	};

class AsciiOut : public UtilityObj {
	public:
		IUtil *iu;
		Interface *ip;
		HWND hPanel;
		ICustButton *iPick;

//		BitmapInfo bi;

		AsciiOut();
		void BeginEditParams(Interface *ip,IUtil *iu);
		void EndEditParams(Interface *ip,IUtil *iu);
		void DeleteThis() {}

		void Init(HWND hWnd);
		void Destroy(HWND hWnd);

		void OutputObject(INode *node);
	};
static AsciiOut theAsciiOut;

class AsciiOutClassDesc:public ClassDesc {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading = FALSE) {return &theAsciiOut;}
	const TCHAR *	ClassName() {return GetString(IDS_RB_ASCIIOBJECTOUT);}
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID		ClassID() {return Class_ID(ASCII_OUT_CLASS_ID);}
	const TCHAR* 	Category() {return _T("Surface Tools");}
	};

static AsciiOutClassDesc asciiOutDesc;
ClassDesc* GetAsciiOutDesc() {return &asciiOutDesc;}

class AsciiOutPickNodeCallback : public PickNodeCallback {
	public:		
		BOOL Filter(INode *node);
	};

BOOL AsciiOutPickNodeCallback::Filter(INode *node)
	{
	ObjectState os = node->EvalWorldState(theAsciiOut.ip->GetTime());
	if (os.obj->SuperClassID()==GEOMOBJECT_CLASS_ID &&
		os.obj->IsRenderable()) return TRUE;
	else return FALSE;
	}

static AsciiOutPickNodeCallback thePickFilt;

class AsciiOutPickModeCallback : public PickModeCallback {
	public:		
		BOOL HitTest(IObjParam *ip,HWND hWnd,ViewExp *vpt,IPoint2 m,int flags);
		BOOL Pick(IObjParam *ip,ViewExp *vpt);
		
		void EnterMode(IObjParam *ip) {theAsciiOut.iPick->SetCheck(TRUE);}
		void ExitMode(IObjParam *ip) {theAsciiOut.iPick->SetCheck(FALSE);}

		PickNodeCallback *GetFilter() {return &thePickFilt;}
		BOOL RightClick(IObjParam *ip,ViewExp *vpt) {return TRUE;}

		HWND h;
	};

static AsciiOutPickModeCallback thePickMode;

BOOL AsciiOutPickModeCallback::HitTest(
		IObjParam *ip,HWND hWnd,ViewExp *vpt,IPoint2 m,int flags)
	{
	return ip->PickNode(hWnd,m,&thePickFilt)?TRUE:FALSE;
	}

BOOL AsciiOutPickModeCallback::Pick(IObjParam *ip,ViewExp *vpt)
	{
	BOOL iret=1;
	INode *node = vpt->GetClosestHit();
	if (node) {
//		iret = TheManager->SelectFileOutput(&theAsciiOut.bi ,theAsciiOut.hPanel ,"Select File");
		if (iret)
			{
//			theAsciiOut.bi.SetWidth(theAsciiOut.Widthspin->GetIVal());
//			theAsciiOut.bi.SetHeight(theAsciiOut.Heightspin->GetIVal());
//			theAsciiOut.bi.SetType(BMM_TRUE_64);
			theAsciiOut.OutputObject(node);
			}
		else
		
		{
			return FALSE;
			}			
		}
	else
		{
		return FALSE;
		}
	return TRUE;
	}


static BOOL CALLBACK AsciiOutDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
	switch (msg) {
		case WM_INITDIALOG:
			theAsciiOut.Init(hWnd);			
			break;
		
		case WM_DESTROY:
			theAsciiOut.Destroy(hWnd);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
/*				case IDOK:
					theAsciiOut.iu->CloseUtility();
					break;				
*/		
				case IDC_ASCIIOUT_PICK:
					theAsciiOut.ip->SetPickMode(&thePickMode); 
					break;
				}
			break;

		default:
			return FALSE;
		}
	return TRUE; 
	}

AsciiOut::AsciiOut()
	{
	iu = NULL;
	ip = NULL;	
	hPanel = NULL;	
	iPick = NULL;
	}

void AsciiOut::BeginEditParams(Interface *ip,IUtil *iu) 
	{
	this->iu = iu;
	this->ip = ip;
	hPanel = ip->AddRollupPage(
		hInstance,
		MAKEINTRESOURCE(IDD_ASCIIOUT_PANEL),
		AsciiOutDlgProc,
		GetString(IDS_RB_ASCIIOBJECTOUT),
		0);
	}
	
void AsciiOut::EndEditParams(Interface *ip,IUtil *iu) 
	{
	ip->ClearPickMode();
	this->iu = NULL;
	this->ip = NULL;
	ip->DeleteRollupPage(hPanel);
	hPanel = NULL;
	}

void AsciiOut::Init(HWND hWnd)
	{
	iPick = GetICustButton(GetDlgItem(hWnd,IDC_ASCIIOUT_PICK));
	iPick->SetType(CBT_CHECK);
	iPick->SetHighlightColor(GREEN_WASH);
	}




void AsciiOut::Destroy(HWND hWnd)
	{
	ReleaseICustButton(iPick);
	iPick = NULL;
	}

class NullView: public View {
	public:
		Point2 ViewToScreen(Point3 p) { return Point2(p.x,p.y); }
		NullView() { worldToView.IdentityMatrix(); screenW=640.0f; screenH = 480.0f; }
	};

void AsciiOut::OutputObject(INode *node2)
	{
//get object	

	// Create a new object through the CreateInstance() API
/*	BezierShape *ashape = (BezierShape*)ip->CreateInstance(
		SHAPE_CLASS_ID,
		Class_ID(SPLINE3D_CLASS_ID,0));
	
	assert(ashape);*/

	Tab<EdgeType> EdgeList;
	EdgeType Temp;
	int i,j;

	ObjectState os = node2->EvalWorldState(theAsciiOut.ip->GetTime());
	assert(os.obj->SuperClassID()==GEOMOBJECT_CLASS_ID);
	BOOL needDel;
	NullView nullView;
	Mesh *mesh = ((GeomObject*)os.obj)->GetRenderMesh(ip->GetTime(),node2,nullView,needDel);
	if (!mesh) return;

	Matrix3 tm = node2->GetObjTMAfterWSM(theAsciiOut.ip->GetTime());
	Matrix3 tm2 = node2->GetNodeTM(theAsciiOut.ip->GetTime());

//	BitArray sel = mesh->VertSel();
	Face *FaceList =  mesh->faces;
	Point3 *VertList = mesh->verts;
	BitArray sel = mesh->edgeSel;

//Indicates the selected edges.  There is one bit for each edge of each face.  Bits that are 1 indicate the edge is selected.  
//The edge is identified by 3*faceIndex + edgeIndex.


//draw lines
//put in ticks

	EdgeList.ZeroCount();
	int found = 0,UseInvis=0;

	if (IsDlgButtonChecked(hPanel,IDC_USEINVISEDGES_CHECK))
		UseInvis =1;

	for (j=0; j<mesh->getNumFaces(); j++) 
		{
//a to b 
		 found = 0;
		 if (sel[3*j + 0])
			{
//add edge a/b to list
			 for (i=0;i<EdgeList.Count();i++)
				{
				 if  
					  (
					   ( (EdgeList[i].a == FaceList->v[0]) && (EdgeList[i].b == FaceList->v[1]) ) ||
					   ( (EdgeList[i].b == FaceList->v[0]) && (EdgeList[i].a == FaceList->v[1]) ) 
					  ) 

					{
					 found = 1;
					}
				}
			 if ( (!found) &&
				 ( (UseInvis) || (FaceList->flags & EDGE_A))
				)
				{
				 Temp.a = FaceList->v[0];
				 Temp.b = FaceList->v[1];
				 Temp.used = 0;
				 Temp.connectedto = -1;
				 EdgeList.Append(1,&Temp,1);
				}
			}
//b to c
		 found = 0;
		 if (sel[3*j + 1])
			{
//add edge b/c to list
			 for (i=0;i<EdgeList.Count();i++)
				{
				 if  (
					  ( (EdgeList[i].a == FaceList->v[1]) && (EdgeList[i].b == FaceList->v[2]) ) ||
					  ( (EdgeList[i].b == FaceList->v[1]) && (EdgeList[i].a == FaceList->v[2]) ) 
					 ) 


					{
					 found = 1;
					}
				}
			 if ( (!found) &&
				 ( (UseInvis) || (FaceList->flags & EDGE_B))
				)
				{
				 Temp.a = FaceList->v[1];
				 Temp.b = FaceList->v[2];
				 Temp.used = 0;
				 Temp.connectedto = -1;
				 EdgeList.Append(1,&Temp,1);
				}
			}

//c to a
		 found = 0;
		 if (sel[3*j + 2])
			{
//add edge c/a to list
			 for (i=0;i<EdgeList.Count();i++)
				{
				 if  (
					  ( (EdgeList[i].a == FaceList->v[2]) && (EdgeList[i].b == FaceList->v[0]) ) ||
					  ( (EdgeList[i].b == FaceList->v[2]) && (EdgeList[i].a == FaceList->v[0]) ) 
					 )

					{
					 found = 1;
					}
				}
			 if ( (!found) &&
				 ( (UseInvis) || (FaceList->flags & EDGE_C))
				)
				{
				 Temp.a = FaceList->v[2];
				 Temp.b = FaceList->v[0];
				 Temp.used = 0;
				 Temp.connectedto = -1;
				 EdgeList.Append(1,&Temp,1);
				}
			}

   		 FaceList++;
		}

//build connection list
/*	for (i=0;i<EdgeList.Count();i++)
		{
		if (EdgeList[i].connectedto == -1)
			{
			EdgeList[i].connectedto == -2;
			for (j=0;j<EdgeList.Count();j++)
				{
				if ((j!=i) && (EdgeList[i].connectedto == -1))
					{
					}
				}
			}
		}
  */
//	BezierShape ashape;
	SplineShape *ashape = new SplineShape;

//  ashape->NewShape();
	// Get parameters from SimpleSpline and place them in the BezierShape
//	int steps;
//	BOOL optimize,adaptive;
//	ipblock->GetValue(IPB_STEPS, t, steps, ivalid);
//	ipblock->GetValue(IPB_OPTIMIZE, t, optimize, ivalid);
//	ipblock->GetValue(IPB_ADAPTIVE, t, adaptive, ivalid);
//shape->steps = 6;
//shape->optimize = 0;

	for (i=0;i<EdgeList.Count();i++)
		{
		Spline3D *Addspline = ashape->shape.NewSpline();

//	Spline3D *Addspline = ashape->NewSpline();
//add verts
// Now add all the necessary points


//Next points or knots are added to the spline by calling AddKnot(). This allows you to add different types of knots and line segments.
		Point3 p(0.0f, 0.0f, 0.0f);
//		spline->KnotPoint(i)
		Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
					VertList[EdgeList[i].a],p,p));
		Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
					VertList[EdgeList[i].b],p,p));
		Addspline->SetOpen();
		Addspline->ComputeBezPoints();

	


	// Create a node in the scene that references the derived object
		}

	INode *node = ip->CreateObjectNode(ashape);
	node->SetNodeTM(theAsciiOut.ip->GetTime(),tm2);
	ashape->shape.UpdateSels();
	ashape->shape.InvalidateGeomCache();
	
	// Name the node and make the name unique.
	TSTR name(_T("Shape"));
	ip->MakeNameUnique(name);
	node->SetName(name);





	// Redraw the views
	ip->RedrawViews(ip->GetTime());

/*
	bit.r = 0;
	bit.g = 0;
	bit.b = 0;
	bit.a = 0xFFFF;


	map->Fill(0xffff,0xffff,0xffff,0);

	ObjectState os = node->EvalWorldState(theAsciiOut.ip->GetTime());
	assert(os.obj->SuperClassID()==GEOMOBJECT_CLASS_ID);
	BOOL needDel;
	NullView nullView;
	Mesh *mesh = ((GeomObject*)os.obj)->GetRenderMesh(ip->GetTime(),node,nullView,needDel);
	if (!mesh) return;

	Matrix3 tm = node->GetObjTMAfterWSM(theAsciiOut.ip->GetTime());

	BitArray sel = mesh->VertSel();
	Face *FaceList =  mesh->faces;
	TVFace	*TVFaceList = mesh->tvFace;

//draw lines
//put in ticks

	for (int i=0; i<mesh->getNumFaces(); i++) 
		{
		 if  (FaceList->flags & HAS_TVERTS)   
			  
			 {
//get tvverst
			 MatID1 = MatIDspin->GetIVal();
			 MatID2 = FaceList->getMatID()+1;
			 if ( (!IsDlgButtonChecked(hPanel,IDC_MATID_CHECK)) ||
				  (MatID1 == MatID2)    )
			 {				 
			 VertA = (Point3) mesh->getTVert(TVFaceList->t[0]);
			 VertB = (Point3) mesh->getTVert(TVFaceList->t[1]);
			 VertC = (Point3) mesh->getTVert(TVFaceList->t[2]);

			 map->PutPixels((int)(map->Width()*VertA.x),map->Height()-1-(int)((map->Height()-1)*VertA.y),1,&bit);
			 map->PutPixels((int)(map->Width()*VertB.x),map->Height()-1-(int)((map->Height()-1)*VertB.y),1,&bit);
			 map->PutPixels((int)(map->Width()*VertC.x),map->Height()-1-(int)((map->Height()-1)*VertC.y),1,&bit);

//Draw Lines from 0A to 1B
			 if ( (FaceList->flags & EDGE_A) || (IsDlgButtonChecked(hPanel,IDC_ALLEDGES_CHECK)) )
				{
				BXPLine((long) (map->Width()*VertA.x),map->Height()-1-(long) ((map->Height()-1)*VertA.y),
						(long) (map->Width()*VertB.x),map->Height()-1-(long) ((map->Height()-1)*VertB.y),
					   0x0000, 0x0000, 0x0000,
					   map,TRUE);

				}
//Draw Lines from 1B to 2C
			 if ( (FaceList->flags & EDGE_B) || (IsDlgButtonChecked(hPanel,IDC_ALLEDGES_CHECK)) )
				{
				BXPLine((long) (map->Width()*VertB.x),map->Height()-1-(long) ((map->Height()-1)*VertB.y),
						(long) (map->Width()*VertC.x),map->Height()-1-(long) ((map->Height()-1)*VertC.y),
					   0x0000, 0x0000, 0x0000,
					   map,TRUE);

				}
//Draw Lines from 1A to 2C
			 if ( (FaceList->flags & EDGE_C) || (IsDlgButtonChecked(hPanel,IDC_ALLEDGES_CHECK)) )
				{
				BXPLine((long) (map->Width()*VertA.x),map->Height()-1-(long) ((map->Height()-1)*VertA.y),
						(long) (map->Width()*VertC.x),map->Height()-1-(long) ((map->Height()-1)*VertC.y),
					   0x0000, 0x0000, 0x0000,
					   map,TRUE);

				}


			 
			 
			 if (sel[FaceList->v[0]])
				{
//draw red tick

				BXPLine((long) (map->Width()*VertA.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertA.y)-4,
						(long) (map->Width()*VertA.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertA.y)+4,
					   0xffff, 0x0000, 0x0000,
					   map,FALSE);
				BXPLine((long) (map->Width()*VertA.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertA.y)-4,
						(long) (map->Width()*VertA.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertA.y)+4,
					   0xffff, 0x0000, 0x0000,
					   map,FALSE);

			 }
			  if (sel[FaceList->v[1]])
				{
//draw red tick
				BXPLine((long) (map->Width()*VertB.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertB.y)-4,
						(long) (map->Width()*VertB.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertB.y)+4,
					   0xffff, 0x0000, 0x0000,
					   map,FALSE);
				BXPLine((long) (map->Width()*VertB.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertB.y)-4,
						(long) (map->Width()*VertB.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertB.y)+4,
					   0xffff, 0x0000, 0x0000,
					   map,FALSE);
				}

			if (sel[FaceList->v[2]])
				{
//draw red tick
				BXPLine((long) (map->Width()*VertC.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertC.y)-4,
						(long) (map->Width()*VertC.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertC.y)+4,
					   0xffff, 0x0000, 0x0000,
					   map,FALSE);
				BXPLine((long) (map->Width()*VertC.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertC.y)-4,
						(long) (map->Width()*VertC.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertC.y)+4,
					   0xffff, 0x0000, 0x0000,
					   map,FALSE);
				}

			}

		 }
		 FaceList++;
		 TVFaceList++;

		}

	map->OpenOutput(&bi);
	map->Write(&bi);
	map->Close(&bi);
*/
	if (needDel) delete mesh;

	}

