/**********************************************************************
 *<
	FILE: cross.cpp

	DESCRIPTION:  Skins cross section

	CREATED BY: Peter Watje

	HISTORY: created Spet 13, 1996

 *>	Copyright (c) 1996, All Rights Reserved.
 **********************************************************************/

#include "mods.h"
#include "iparamm.h"
#include "shape.h"
#include "spline3d.h"
#include "splshape.h"
#include "linshape.h"

//--- ExtrudeMod -----------------------------------------------------------

#define EDITSPL_CHANNELS (PART_GEOM|SELECT_CHANNEL|PART_SUBSEL_TYPE|PART_DISPLAY|PART_TOPO)

#define MIN_AMOUNT		float(-1.0E30)
#define MAX_AMOUNT		float(1.0E30)

#define SPLINETYPE 0
#define MESHTYPE 0

#define PATCH_OUTPUT 0

#define DEF_OUTPUT MESH_OUTPUT //PATCH_OUTPUT

#define PW_PATCH_TO_SPLINE1 0x39095e89
#define PW_PATCH_TO_SPLINE2 0x63ec268d

//#define DEBUG 1


class SegmentType
	{
	public:
	int a,b;
	int used;
	};


class ExtrudeMod: public Modifier {
	
	protected:
		IParamBlock *pblock;

		static IObjParam *ip;
		
	public:
		static IParamMap *pmapParam;
		
		static int splinetype;
		static int meshtype,UOut,VOut,CapStart,CapEnd;
		static int vsplinetype;

		Tab<Point3> VertList;
		Tab<SegmentType> SegmentList;

		int GetPointIndex(Point3 point);


		// From Animatable
		void DeleteThis() { delete this; }
		void GetClassName(TSTR& s) { s= GetString(IDS_RB_CROSSSECT); }  
		virtual Class_ID ClassID() { return Class_ID(PW_PATCH_TO_SPLINE1,PW_PATCH_TO_SPLINE2);}		
		RefTargetHandle Clone(RemapDir& remap = NoRemap());
		TCHAR *GetObjectName() { return GetString(IDS_RB_CROSSSECT); }
		IOResult Load(ILoad *iload);

		ExtrudeMod();
		virtual ~ExtrudeMod();

		ChannelMask ChannelsUsed()  { return EDITSPL_CHANNELS; }
		ChannelMask ChannelsChanged() { return EDITSPL_CHANNELS; }


//		ChannelMask ChannelsUsed()  { return PART_GEOM|PART_TOPO; }
		// Possible GOTCHA -- Modifiers like this one, which completely change the type of
		// object (shape -> Mesh or Patch) change ALL channels!  Be sure to tell the system!
//		ChannelMask ChannelsChanged() { return PART_ALL; }
		void ModifyObject(TimeValue t, ModContext &mc, ObjectState *os, INode *node);

//		void NotifyInputChanged(Interval changeInt, PartID partID, RefMessage message, ModContext *mc);
		Class_ID InputType() { return Class_ID(TRIOBJ_CLASS_ID,0); }
		
//		Class_ID InputType() {return genericShapeClassID;}
		Interval LocalValidity(TimeValue t);

		// From BaseObject
		BOOL ChangeTopology() {return TRUE;}
		IParamArray *GetParamBlock() {return pblock;}
		int GetParamBlockIndex(int id) {return id;}

		int NumRefs() {return 1;}
		RefTargetHandle GetReference(int i) {return pblock;}
		void SetReference(int i, RefTargetHandle rtarg) {pblock=(IParamBlock*)rtarg;}

 		int NumSubs() { return 1; }  
		Animatable* SubAnim(int i) { return pblock; }
		TSTR SubAnimName(int i) { return TSTR(GetString(IDS_RB_PARAMETERS));}		

		RefResult NotifyRefChanged( Interval changeInt,RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message);

		CreateMouseCallBack* GetCreateMouseCallBack() {return NULL;} 

		void BeginEditParams(IObjParam *ip, ULONG flags,Animatable *prev);
		void EndEditParams(IObjParam *ip, ULONG flags,Animatable *next);

		void BuildSkin(TimeValue t,ModContext &mc, ObjectState * os);
		int IsConnected(Face *FList,DWORD ct, DWORD a, DWORD b);
		int IsAllConnected(Face *FList,DWORD ct, DWORD a, DWORD b);

		void UpdateUI(TimeValue t) {}
		Interval GetValidity(TimeValue t);
		ParamDimension *GetParameterDim(int pbIndex);
		TSTR GetParameterName(int pbIndex);
	};

class ExtrudeClassDesc:public ClassDesc {
	public:
	int 			IsPublic() { return 1; }
	void *			Create(BOOL loading = FALSE) { return new ExtrudeMod; }
	const TCHAR *	ClassName() { return GetString(IDS_RB_CROSSSECT); }
	SClass_ID		SuperClassID() { return OSM_CLASS_ID; }
	Class_ID		ClassID() { return  Class_ID(PW_PATCH_TO_SPLINE1,PW_PATCH_TO_SPLINE2); }
	const TCHAR* 	Category() { return GetString(IDS_RB_PATCH);}
	};

static ExtrudeClassDesc extrudeDesc;
extern ClassDesc* GetExtrudeModDesc() { return &extrudeDesc; }

IObjParam*		ExtrudeMod::ip          = NULL;
IParamMap *		ExtrudeMod::pmapParam = NULL;
int				ExtrudeMod::splinetype = SPLINETYPE;
int				ExtrudeMod::meshtype = MESHTYPE;
int				ExtrudeMod::UOut = 1;
int				ExtrudeMod::VOut = 1;
int				ExtrudeMod::CapStart = 0;
int				ExtrudeMod::CapEnd = 0;
int				ExtrudeMod::vsplinetype = SPLINETYPE;
 

//--- Parameter map/block descriptors -------------------------------

static int outputIDs[] = {IDC_RADIO1,IDC_RADIO2,IDC_RADIO3,IDC_RADIO4};
static int VoutputIDs[] = {IDC_RADIO5,IDC_RADIO6,IDC_RADIO7,IDC_RADIO8};

static int meshIDs[] = {IDC_REGULAR_RADIO,IDC_IRREGULAR_RADIO};


#define PB_SPLINETYPE	0
#define PB_MESHTYPE		1
#define PB_VSPLINETYPE	2
#define PB_UOUT			3
#define PB_VOUT			4
#define PB_CAPSTART		5
#define PB_CAPEND		6



//
//
// Parameters


static ParamUIDesc descParam[] = {
	// Spline type
	ParamUIDesc(PB_SPLINETYPE,TYPE_RADIO,outputIDs,4),

	// Mesh type
	ParamUIDesc(PB_MESHTYPE,TYPE_RADIO,meshIDs,2),

	 // VSpline type
	ParamUIDesc(PB_VSPLINETYPE,TYPE_RADIO,VoutputIDs,4),

	// UOuput
   ParamUIDesc(PB_UOUT,TYPE_SINGLECHEKBOX,IDC_UOUT_CHECK),

   // VOuput
   ParamUIDesc(PB_VOUT,TYPE_SINGLECHEKBOX,IDC_VOUT_CHECK),

   	// UOuput
   ParamUIDesc(PB_CAPSTART,TYPE_SINGLECHEKBOX,IDC_SCAP_CHECK),

   // VOuput
   ParamUIDesc(PB_CAPEND,TYPE_SINGLECHEKBOX,IDC_ECAP_CHECK)



	};
#define PARAMDESC_LENGTH 7


static ParamBlockDescID descVer0[] = {
	{ TYPE_FLOAT, NULL, TRUE, 0 },
	{ TYPE_INT, NULL, TRUE, 1 },
	{ TYPE_INT, NULL, FALSE, 2 },
	{ TYPE_INT, NULL, FALSE, 3 } };

static ParamBlockDescID descVer1[] = {
	{ TYPE_FLOAT, NULL, TRUE, 0 },
	{ TYPE_INT, NULL, TRUE, 1 },
	{ TYPE_INT, NULL, FALSE, 2 },
	{ TYPE_INT, NULL, FALSE, 3 },
	{ TYPE_INT, NULL, FALSE, 4 } };

static ParamBlockDescID descVer2[] = {
	{ TYPE_FLOAT, NULL, TRUE, 0 },
	{ TYPE_INT, NULL, TRUE, 1 },
	{ TYPE_INT, NULL, FALSE, 2 },
	{ TYPE_INT, NULL, FALSE, 3 },
	{ TYPE_INT, NULL, FALSE, 4 },
	{ TYPE_INT, NULL, FALSE, 5 } };

static ParamBlockDescID descVer3[] = {
	{ TYPE_INT, NULL, FALSE, 0 },
	{ TYPE_INT, NULL, FALSE, 1 },
	{ TYPE_INT, NULL, FALSE, 2 },
	{ TYPE_INT, NULL, FALSE, 3 },
	{ TYPE_INT, NULL, FALSE, 4 },
	{ TYPE_INT, NULL, FALSE, 5 },
	{ TYPE_INT, NULL, FALSE, 6 }
	 };

#define PBLOCK_LENGTH	7

// Array of old versions
static ParamVersionDesc versions[] = {
	ParamVersionDesc(descVer0,4,0),
	ParamVersionDesc(descVer1,5,1),	
	ParamVersionDesc(descVer2,6,2)	
	};
#define NUM_OLDVERSIONS	3

// Current version
#define CURRENT_VERSION	5
static ParamVersionDesc curVersion(descVer3,PBLOCK_LENGTH,CURRENT_VERSION);

ExtrudeMod::ExtrudeMod()
	{
	MakeRefByID(FOREVER, 0, 
		CreateParameterBlock(descVer3, PBLOCK_LENGTH, CURRENT_VERSION));
	pblock->SetValue(PB_SPLINETYPE, TimeValue(0), splinetype);
	pblock->SetValue(PB_VSPLINETYPE, TimeValue(0), vsplinetype);
	pblock->SetValue(PB_MESHTYPE, TimeValue(0), meshtype);
	pblock->SetValue(PB_UOUT,TimeValue(0), UOut);
	pblock->SetValue(PB_VOUT,TimeValue(0), VOut);
	pblock->SetValue(PB_CAPSTART,TimeValue(0), CapStart);
	pblock->SetValue(PB_CAPEND,TimeValue(0), CapEnd);
	
	}

ExtrudeMod::~ExtrudeMod()
	{	
	}

Interval ExtrudeMod::LocalValidity(TimeValue t)
	{
	// if being edited, return NEVER forces a cache to be built 
	// after previous modifier.
	if (TestAFlag(A_MOD_BEING_EDITED))
		return NEVER;  
	Interval valid = GetValidity(t);	
	return valid;
	}

RefTargetHandle ExtrudeMod::Clone(RemapDir& remap)
	{
	ExtrudeMod* newmod = new ExtrudeMod();	
	newmod->ReplaceReference(0,pblock->Clone(remap));
	BaseClone(this, newmod, remap);
	return(newmod);
	}

void ExtrudeMod::ModifyObject(TimeValue t, ModContext &mc, ObjectState * os, INode *node) 
	{	
//DebugPrint("Extrude modifying object\n");

	// Get our personal validity interval...
	Interval valid = GetValidity(t);
	// and intersect it with the channels we use as input (see ChannelsUsed)
	valid &= os->obj->ChannelValidity(t,TOPO_CHAN_NUM);
	valid &= os->obj->ChannelValidity(t,GEOM_CHAN_NUM);
	Matrix3 modmat,minv;
	
//	int output;


//Dump from spline to patch
		// Here is where all the fun stuff happens -- BuildPatchFromShape fills in the PatchObject's patch mesh,
		// then we stuff the PatchObject into the pipeline.
	
	

	BuildSkin(t, mc, os);

	


	os->obj->SetChannelValidity(TOPO_CHAN_NUM, valid);
	os->obj->SetChannelValidity(GEOM_CHAN_NUM, valid);
	os->obj->SetChannelValidity(TEXMAP_CHAN_NUM, valid);
	os->obj->SetChannelValidity(MTL_CHAN_NUM, valid);
	os->obj->SetChannelValidity(SELECT_CHAN_NUM, valid);
	os->obj->SetChannelValidity(SUBSEL_TYPE_CHAN_NUM, valid);
	os->obj->SetChannelValidity(DISP_ATTRIB_CHAN_NUM, valid);

//	os->obj = pat;

	os->obj->UnlockObject();
//	os->obj->InvalidateGeomCache();

	}


void ExtrudeMod::BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev )
	{
	this->ip = ip;

	TimeValue t = ip->GetTime();

		// Disable show end result.
	ip->EnableShowEndResult(FALSE);



	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_BEGIN_EDIT);
	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_MOD_DISPLAY_ON);

	SetAFlag(A_MOD_BEING_EDITED);

	pmapParam = CreateCPParamMap(
		descParam,PARAMDESC_LENGTH,
		pblock,
		ip,
		hInstance,
		MAKEINTRESOURCE(IDD_WELD),
		GetString(IDS_RB_PARAMETERS),
		0);	
	}

void ExtrudeMod::EndEditParams( IObjParam *ip, ULONG flags,Animatable *next)
	{
	this->ip = NULL;
	
	TimeValue t = ip->GetTime();

	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_END_EDIT);
	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_MOD_DISPLAY_OFF);
	ClearAFlag(A_MOD_BEING_EDITED);

	DestroyCPParamMap(pmapParam);

	// Save these values in class variables so the next object created will inherit them.
	pblock->GetValue(PB_SPLINETYPE,ip->GetTime(),splinetype,FOREVER);
	pblock->GetValue(PB_VSPLINETYPE,ip->GetTime(),vsplinetype,FOREVER);
	pblock->GetValue(PB_MESHTYPE,ip->GetTime(),meshtype,FOREVER);
	pblock->GetValue(PB_UOUT,ip->GetTime(),UOut,FOREVER);
	pblock->GetValue(PB_VOUT,ip->GetTime(),VOut,FOREVER);
	pblock->GetValue(PB_CAPSTART,ip->GetTime(),CapStart,FOREVER);
	pblock->GetValue(PB_CAPEND,ip->GetTime(),CapEnd,FOREVER);

	}

Interval ExtrudeMod::GetValidity(TimeValue t)
	{
//	float f;
//	int i;
	Interval valid = FOREVER;
	return valid;
	}

RefResult ExtrudeMod::NotifyRefChanged(
		Interval changeInt, 
		RefTargetHandle hTarget, 
   		PartID& partID, 
   		RefMessage message ) 
   	{
	switch (message) {
		case REFMSG_GET_PARAM_DIM: {
			GetParamDim *gpd = (GetParamDim*)partID;
			gpd->dim = GetParameterDim(gpd->index);			
			return REF_STOP; 
			}

		case REFMSG_GET_PARAM_NAME: {
			GetParamName *gpn = (GetParamName*)partID;
			gpn->name = GetParameterName(gpn->index);			
			return REF_STOP; 
			}
		}
	return(REF_SUCCEED);
	}

ParamDimension *ExtrudeMod::GetParameterDim(int pbIndex)
	{
	return defaultDim;
	}

TSTR ExtrudeMod::GetParameterName(int pbIndex)
	{
	return TSTR(_T(""));
	}

IOResult ExtrudeMod::Load(ILoad *iload)
	{
	Modifier::Load(iload);
	iload->RegisterPostLoadCallback(
		new ParamBlockPLCB(versions,NUM_OLDVERSIONS,&curVersion,this,0));
	return IO_OK;
	}


// Quad patch layout
//
//   A---> ad ----- da <---D
//   |                     |
//   |                     |
//   v                     v
//   ab    i1       i4     dc
//
//   |                     |
//   |                     |
// 
//   ba    i2       i3     cd
//   ^					   ^
//   |                     |
//   |                     |
//   B---> bc ----- cb <---C
//
// vertices ( a b c d ) are in counter clockwise order when viewed from 
// outside the surface

int ExtrudeMod::GetPointIndex(Point3 point)
{
for (int i=0;i<VertList.Count();i++)
	{
	if (VertList[i] == point)
		return i;
	}
return 0;
};


int ExtrudeMod::IsConnected(Face *Flist,DWORD ct, DWORD a, DWORD b)

{
  DWORD j;
  j = a*2;
 //for (DWORD j=0;j<ct;j++)
//	{
	if ( ( (((Flist[j].v[0]==a) && (Flist[j].v[1]==b)) || ((Flist[j].v[0]==b) && (Flist[j].v[1]==a))) && (Flist[j].flags & EDGE_A) ) 
//		 ( (((Flist[j].v[1]==a) && (Flist[j].v[2]==b)) || ((Flist[j].v[1]==b) && (Flist[j].v[2]==a))) && (Flist[j].flags & EDGE_B) ) ||
//		 ( (((Flist[j].v[2]==a) && (Flist[j].v[0]==b)) || ((Flist[j].v[2]==b) && (Flist[j].v[0]==a))) && (Flist[j].flags & EDGE_C) ) 
	    )
		{
		return 1;
		}
//	}
return 0;
}

int ExtrudeMod::IsAllConnected(Face *Flist,DWORD ct, DWORD a, DWORD b)

{
for (DWORD j=0;j<ct;j++)
	{
	if ( ( (((Flist[j].v[0]==a) && (Flist[j].v[1]==b)) || ((Flist[j].v[0]==b) && (Flist[j].v[1]==a))) && (Flist[j].flags & EDGE_A) ) ||
		 ( (((Flist[j].v[1]==a) && (Flist[j].v[2]==b)) || ((Flist[j].v[1]==b) && (Flist[j].v[2]==a))) && (Flist[j].flags & EDGE_B) ) ||
		 ( (((Flist[j].v[2]==a) && (Flist[j].v[0]==b)) || ((Flist[j].v[2]==b) && (Flist[j].v[0]==a))) && (Flist[j].flags & EDGE_C) ) 
	    )
		{
		return 1;
		}
	}
return 0;
}


void ExtrudeMod::BuildSkin(TimeValue t,ModContext &mc, ObjectState * os) {



SplineShape *shape = new SplineShape;
DWORD ASpline,CVert,i,j;
int KType,K;
int KVType,KV;
DWORD FirstPoint;
int OV,OU;
int CE,CS;


assert(os->obj->IsSubClassOf(triObjectClassID));
TriObject *triOb = (TriObject *)os->obj;


pblock->GetValue(PB_SPLINETYPE,t,K,FOREVER);
pblock->GetValue(PB_VSPLINETYPE,t,KV,FOREVER);
pblock->GetValue(PB_UOUT,t,OU,FOREVER);
pblock->GetValue(PB_VOUT,t,OV,FOREVER);

pblock->GetValue(PB_CAPSTART,t,CS,FOREVER);
pblock->GetValue(PB_CAPEND,t,CE,FOREVER);

if (CS)
	CS = 1;
	else CS = 0;

if (CE)
	CE = 1;
	else CE = 0;




if (K == 0)
		KType = KTYPE_CORNER;
else if (K == 1)
		KType = KTYPE_AUTO;
else if (K == 2)
		KType = KTYPE_BEZIER;
else if (K == 3)
		KType = KTYPE_BEZIER_CORNER;


if (KV == 0)
		KVType = KTYPE_CORNER;
else if (KV == 1)
		KVType = KTYPE_AUTO;
else if (KV == 2)
		KVType = KTYPE_BEZIER;
else if (KV == 3)
		KVType = KTYPE_BEZIER_CORNER;


CVert = 0;
ASpline = 1;
FirstPoint = 0;
Spline3D *Addspline = NULL;
Point3 p(0.0f, 0.0f, 0.0f);
int StartNewSpline=1;
int UCount=0,VCount = 0,FCount=0;
for (i=0+CS;i<(DWORD)(triOb->mesh.numVerts-1-CE);i++)
		{
		
		if (StartNewSpline)
			{
			 VCount++;
			 FCount++;
			 if (FCount==1) UCount++;
			 if ((Addspline != NULL) && (Addspline->KnotCount() != 0))
				{
//check if loop
				p = triOb->mesh.verts[i-1];
				if (OU)
					Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
									triOb->mesh.verts[i-1],p,p));
				if (OU)
					{
					if (IsAllConnected(triOb->mesh.faces,(DWORD)triOb->mesh.numFaces, FirstPoint, i-1))
						  Addspline->SetClosed();
						else Addspline->SetOpen();
					Addspline->ComputeBezPoints();
					for (int poly=0;poly<Addspline->KnotCount();poly++)
						Addspline->SetKnotType(poly,KType);
					Addspline->ComputeBezPoints();
					}

				}
			 FirstPoint = i;
			 if (OU)
				{
				if (Addspline == NULL)
					Addspline = shape->shape.NewSpline();
				else if (Addspline->KnotCount() != 0)
					Addspline = shape->shape.NewSpline();
				}
			}


//check if next point connected to current point
	    StartNewSpline = 1;
		if  (IsAllConnected(triOb->mesh.faces,(DWORD)triOb->mesh.numFaces, i, i+1)) 
		   	
			{
			if ((i-1) == FirstPoint)
				{
				p = triOb->mesh.verts[i];

				if (OU)
					Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
									triOb->mesh.verts[i],p,p));
				if (FCount==1) UCount++;
				StartNewSpline = 0;
				}
			else if (!IsAllConnected(triOb->mesh.faces,(DWORD)triOb->mesh.numFaces, i, FirstPoint))  
				{
				p = triOb->mesh.verts[i];

				if (OU)
					Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
									triOb->mesh.verts[i],p,p));
				if (FCount==1) UCount++;
				StartNewSpline = 0;
				}
			}

		}


//check if loop
if (OU)
	{
	p = triOb->mesh.verts[i];

	Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
							triOb->mesh.verts[i],p,p));
	if (IsAllConnected(triOb->mesh.faces,(DWORD)triOb->mesh.numFaces, FirstPoint, i))
		  Addspline->SetClosed();
		else Addspline->SetOpen();
	Addspline->ComputeBezPoints();
	for (int poly=0;poly<Addspline->KnotCount();poly++)
		Addspline->SetKnotType(poly,KType);
	Addspline->ComputeBezPoints();
	}

if (OV)
	{
	for (i=0;i<(DWORD)(UCount);i++)
		{
		Addspline = shape->shape.NewSpline();
		if (CS) 
			{
			p = triOb->mesh.verts[0];
			Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
							triOb->mesh.verts[0],p,p));
			}
		for (j=0;j<(DWORD)(VCount);j++)
			{
			p = triOb->mesh.verts[CS+i+(j*UCount)];
			Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
							triOb->mesh.verts[CS+i+(j*UCount)],p,p));

			}
		if (CE)

			{
			p = triOb->mesh.verts[triOb->mesh.numVerts-1];
			Addspline->AddKnot(SplineKnot(KTYPE_AUTO,LTYPE_CURVE,
							triOb->mesh.verts[triOb->mesh.numVerts-1],p,p));
			}

		if (IsAllConnected(triOb->mesh.faces,(DWORD)triOb->mesh.numFaces, i, i+((j-1)*UCount)))
			  Addspline->SetClosed();
			else Addspline->SetOpen();
		Addspline->ComputeBezPoints();
		for (int poly=0;poly<Addspline->KnotCount();poly++)
				Addspline->SetKnotType(poly,KVType);
		Addspline->ComputeBezPoints();
		}
//weld looping splines
	}
shape->shape.UpdateSels();
shape->shape.InvalidateGeomCache();

shape->SetChannelValidity(TOPO_CHAN_NUM, FOREVER);
shape->SetChannelValidity(GEOM_CHAN_NUM, FOREVER);
shape->SetChannelValidity(TEXMAP_CHAN_NUM, FOREVER);
shape->SetChannelValidity(MTL_CHAN_NUM, FOREVER);
shape->SetChannelValidity(SELECT_CHAN_NUM, FOREVER);
shape->SetChannelValidity(SUBSEL_TYPE_CHAN_NUM, FOREVER);
shape->SetChannelValidity(DISP_ATTRIB_CHAN_NUM, FOREVER);


os->obj = shape;

os->obj->UnlockObject();


}
