/**********************************************************************
 *<
	FILE: afregion.cpp

	DESCRIPTION:  Affect region modifier

	CREATED BY: Rolf Berteig

	HISTORY: 10/16/96

 *>	Copyright (c) 1994, All Rights Reserved.
 **********************************************************************/

#include "mods.h"
#include "iparamm.h"
#include "iparamm.h"
#include "IParticleObjectExt.h"

// This is based on the simple spline object...

#include "Simpobj.h"


#define PBLOCK_REF	0
#define PARTICLENODE_REF	1
#define LAZYID 0xDE17A345, 0x8A41E2AD

class AFRMod : public Modifier {	
	public:
		IParamBlock *pblock;
		BYTE sel[1];
		HWND hWnd;
		static IObjParam *ip;
		static IParamMap *pmapParam;
		
		AFRMod();
		~AFRMod() {
				DeleteAllRefsFromMe();
				pblock = NULL;
				}

		INode *BaseNode;
		INode *ParticleNode;
		Tab<Point3> DisplaceList;
		Tab<Point3> TempList;
		Tab<Point3> VelList;
		float Strength, Radius;
		int Remember,Velocity,Curve;
		int x,y,z;
		float RimStrength, RimRadius;
		void GetMyINodes();		
		// From Animatable
		void DeleteThis() { delete this; }
		void GetClassName(TSTR& s) {s = GetString(IDS_RB_AFRMOD);}  
		virtual Class_ID ClassID() { return Class_ID(LAZYID);}		
		void BeginEditParams(IObjParam  *ip, ULONG flags,Animatable *prev);
		void EndEditParams(IObjParam *ip,ULONG flags,Animatable *next);		
		RefTargetHandle Clone(RemapDir& remap = NoRemap());
		TCHAR *GetObjectName() {return GetString(IDS_RB_AFRMOD);}

		// From modifier
		ChannelMask ChannelsUsed()  {return PART_GEOM|PART_TOPO|PART_SELECT|PART_SUBSEL_TYPE;}
		ChannelMask ChannelsChanged() {return PART_GEOM;}
		Class_ID InputType() {return defObjectClassID;}
	
		int Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc);

		void ModifyObject(TimeValue t, ModContext &mc, ObjectState *os, INode *node);
		Interval LocalValidity(TimeValue t);

		// From BaseObject
		CreateMouseCallBack* GetCreateMouseCallBack() {return NULL;} 

		int NumRefs() {return 2;}
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);

		int NumSubs() {return 1;}
		Animatable* SubAnim(int i); 
		TSTR SubAnimName(int i);

		RefResult NotifyRefChanged( Interval changeInt,RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message);

	};


class AFRDeformer : public Deformer {
	public:		

		AFRMod *mod;
		AFRDeformer(AFRMod *m) {mod = m;}
		Point3 Map(int i, Point3 p);
	};


//--- ClassDescriptor and class vars ---------------------------------

IParamMap       *AFRMod::pmapParam = NULL;
IObjParam       *AFRMod::ip        = NULL;
		

class AFRClassDesc:public ClassDesc {
	public:
	int 			IsPublic() { return 1; }
	void *			Create(BOOL loading = FALSE) { return new AFRMod; }
	const TCHAR *	ClassName() { return GetString(IDS_RB_AFRMOD); }
	SClass_ID		SuperClassID() { return OSM_CLASS_ID; }
	Class_ID		ClassID() { return Class_ID(LAZYID); }
	const TCHAR* 	Category() { return GetString(IDS_RB_DEFDEFORMATIONS);}
	};

static AFRClassDesc afrDesc;
extern ClassDesc* GetAFRModDesc() {return &afrDesc;}


//--- Parameter map/block descriptors -------------------------------

static int outputIDs[] = {IDC_RADIO1,IDC_RADIO2,IDC_RADIO3,IDC_RADIO4, IDC_RADIO5};


#define PB_STRENGTH		0
#define PB_RADIUS		1
#define PB_REMEMBER		2
#define PB_VELOCITY		3
#define PB_CURVE		4
#define PB_X			5
#define PB_Y			6
#define PB_Z			7


//
//
// Parameters

static ParamUIDesc descParam[] = {
	// Str
	ParamUIDesc(
		PB_STRENGTH,
		EDITTYPE_FLOAT,
		IDC_STRENGTH,IDC_STRENGTH_SPIN,
		-BIGFLOAT,BIGFLOAT,
		SPIN_AUTOSCALE),

	// Rad
	ParamUIDesc(
		PB_RADIUS,
		EDITTYPE_FLOAT,
		IDC_RADIUS,IDC_RADIUS_SPIN,
		0.001f,BIGFLOAT,
		SPIN_AUTOSCALE),

	// REMEMBER
   ParamUIDesc(PB_REMEMBER,TYPE_SINGLECHEKBOX,IDC_REMEMBER),

   // Velocity
   ParamUIDesc(PB_VELOCITY,TYPE_SINGLECHEKBOX,IDC_VELOCITY),

	// Curve type
	ParamUIDesc(PB_CURVE,TYPE_RADIO,outputIDs,5),

   // X
   ParamUIDesc(PB_X,TYPE_SINGLECHEKBOX,IDC_X),
   // Y
   ParamUIDesc(PB_Y,TYPE_SINGLECHEKBOX,IDC_Y),
   // Z
   ParamUIDesc(PB_Z,TYPE_SINGLECHEKBOX,IDC_Z),



	};
#define PARAMDESC_LENGTH	8

static ParamBlockDescID descVer0[] = {
	{ TYPE_FLOAT, NULL, TRUE,  0 },		// Falloff	
	{ TYPE_FLOAT, NULL, TRUE,  1 },		// Settle	
	{ TYPE_INT, NULL, FALSE,  2 },		// Remeber	
	{ TYPE_INT, NULL, FALSE,  3 },		// Velocity	
	{ TYPE_INT, NULL, FALSE,  4 },		// Curve	
	{ TYPE_INT, NULL, FALSE,  5 },		// X	
	{ TYPE_INT, NULL, FALSE,  6 },		// Y	
	{ TYPE_INT, NULL, FALSE,  7 },		// Z
	};
#define PBLOCK_LENGTH	8

#define CURRENT_VERSION	0




//This handles the output of particle info
//Hit Dialog

class DumpHitDialog : public HitByNameDlgCallback {
public:
	AFRMod *eo;
	DumpHitDialog(AFRMod *e) {eo=e;};
	TCHAR *dialogTitle() {return _T("Select Particle System");};
	TCHAR *buttonText() {return _T("Select");};
	BOOL singleSelect() {return TRUE;};
	BOOL useProc() {return TRUE;};
	int filter(INode *node);
	void proc(INodeTab &nodeTab);
	};

void DumpHitDialog::proc(INodeTab &nodeTab)

{

eo->ReplaceReference(1,nodeTab[0]);
eo->NotifyDependents(FOREVER, TOPO_CHANNEL, REFMSG_CHANGE);
SendMessage(GetDlgItem(eo->hWnd,IDC_ADD), WM_SETTEXT, 0, (LPARAM)nodeTab[0]->GetName());
}





int DumpHitDialog::filter(INode *node)

{
	ObjectState os = node->EvalWorldState(eo->ip->GetTime());
//filter only particle objects
	if (os.obj->GetInterface(I_PARTICLEOBJ)==NULL)
		return FALSE;
		else return TRUE;

}


class MapDlgProc : public ParamMapUserDlgProc {
	public:
		AFRMod *mod;		
		MapDlgProc(AFRMod *m) {mod = m;}		
		BOOL DlgProc(TimeValue t,IParamMap *map,HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);		
		void DeleteThis() {delete this;}
		void DoBitmapFit(HWND hWnd);
	};

BOOL MapDlgProc::DlgProc(
		TimeValue t,IParamMap *map,HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
	{

	switch (msg) {
		case WM_INITDIALOG:


			mod->hWnd = hWnd;

			if (mod->ParticleNode != NULL)
				SendMessage(GetDlgItem(mod->hWnd,IDC_ADD), WM_SETTEXT, 0, (LPARAM)mod->ParticleNode->GetName());


			break;

		case WM_COMMAND:

			switch (LOWORD(wParam)) {
				case IDC_ADD:
					mod->ip->DoHitByNameDialog(new DumpHitDialog(mod));

					break;
				}
			break;


		}
	return FALSE;
	}






//--- Affect region mod methods -------------------------------

AFRMod::AFRMod() 
	{
	MakeRefByID(
		FOREVER, PBLOCK_REF, 
		CreateParameterBlock(
			descVer0, PBLOCK_LENGTH, CURRENT_VERSION));
	
	ParticleNode = NULL;
	BaseNode = NULL;
	sel[0] = 0;
	pblock->SetValue(PB_STRENGTH,0,10.0f);
	pblock->SetValue(PB_RADIUS,0,30.0f);
	pblock->SetValue(PB_REMEMBER,0,0);
	pblock->SetValue(PB_VELOCITY,0,1);

	pblock->SetValue(PB_CURVE,0,0);
	pblock->SetValue(PB_X,0,1);
	pblock->SetValue(PB_Y,0,1);
	pblock->SetValue(PB_Z,0,1);

	}

void AFRMod::BeginEditParams(
		IObjParam  *ip, ULONG flags,Animatable *prev)
	{
	this->ip = ip;

	
	TimeValue t = ip->GetTime();
	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_BEGIN_EDIT);
	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_MOD_DISPLAY_ON);
	SetAFlag(A_MOD_BEING_EDITED);

	pmapParam = CreateCPParamMap(
		descParam,PARAMDESC_LENGTH,
		pblock,
		ip,
		hInstance,
		MAKEINTRESOURCE(IDD_AFRPARAM),
		GetString(IDS_RB_PARAMETERS),
		0);	
	pmapParam->SetUserDlgProc(new MapDlgProc(this));

	}

void AFRMod::EndEditParams(
		IObjParam *ip,ULONG flags,Animatable *next)
	{
	this->ip = NULL;
	TimeValue t = ip->GetTime();

	// NOTE: This flag must be cleared before sending the REFMSG_END_EDIT
	ClearAFlag(A_MOD_BEING_EDITED);

	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_END_EDIT);
	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_MOD_DISPLAY_OFF);


	DestroyCPParamMap(pmapParam);
	}

RefTargetHandle AFRMod::Clone(RemapDir& remap)
	{
	AFRMod *mod = new AFRMod();
	mod->ReplaceReference(PBLOCK_REF,pblock->Clone(remap));
	BaseClone(this, mod, remap);
//	mod->ReplaceReference(PARTICLENODE_REF,ParticleNode->Clone(remap));
	return mod;
	}



int AFRMod::Display(
		TimeValue t, INode* inode, ViewExp *vpt, 
		int flagst, ModContext *mc)
	{

//	BaseNode = inode;
	return 0;

	}



class MyEnumProc : public DependentEnumProc 
	{
      public :
      virtual int proc(ReferenceMaker *rmaker); 
      INodeTab Nodes;              
	};

int MyEnumProc::proc(ReferenceMaker *rmaker) 
	{ 
	if (rmaker->SuperClassID()==BASENODE_CLASS_ID)    
			{
            Nodes.Append(1, (INode **)&rmaker);                 
			}
     return 0;              
	}

void AFRMod::GetMyINodes()              
	{
     MyEnumProc dep;              
	 EnumDependents(&dep);
	 BaseNode = dep.Nodes[0];
/*
     for( int i = 0 ; i < dep.Nodes.Count() ; i++) 
		{
                  //Do What you want with your Nodes                   
		}
*/
        return;              
	}

void AFRMod::ModifyObject(
		TimeValue t, ModContext &mc, ObjectState *os, INode *node)
	{	

	int nv = os->obj->NumPoints();




	Point3 Center;
	Interval iv = FOREVER;

	pblock->GetValue(PB_STRENGTH,t,Strength,iv);
	pblock->GetValue(PB_RADIUS,t,Radius,iv);
	pblock->GetValue(PB_REMEMBER,t,Remember,iv);
	pblock->GetValue(PB_VELOCITY,t,Velocity,iv);
	pblock->GetValue(PB_CURVE,t,Curve,iv);

	pblock->GetValue(PB_X,t,x,iv);
	pblock->GetValue(PB_Y,t,y,iv);
	pblock->GetValue(PB_Z,t,z,iv);
	iv.Set(t,t);

	if ((t==0) || (DisplaceList.Count() != nv))
		{
		DisplaceList.ZeroCount();
		Point3 p(0.0f,0.0f,0.0f);
		for (int i = 0; i < nv; i++)
			DisplaceList.Append(1,&p,1);
		}

// get inverse tm for 
	Matrix3 itm;
	TempList.ZeroCount();
	VelList.ZeroCount();
	if (BaseNode == NULL)
		GetMyINodes();              
	if (BaseNode != NULL) //(nodes.Count() > 0)
		{
//		itm = Inverse(nodes[0]->GetObjectTM(t));
		itm = Inverse(BaseNode->GetObjectTM(t));

//get particle node

		if (ParticleNode != NULL)
			{
			Matrix3 ptm = ParticleNode->GetObjectTM(t);
			SimpleParticle *particles;
			ObjectState pos = ParticleNode->EvalWorldState(t);

			IParticleObjectExt* epobj = (IParticleObjectExt*) pos.obj->GetInterface(PARTICLEOBJECTEXT_INTERFACE);
	
			if (epobj) 
			{
				epobj->UpdateParticles(node, t);

				int count = epobj->NumParticles();
				for (int pid = 0; pid < count; pid++)
				{
					TimeValue age  = epobj->GetParticleAgeByIndex(pid);
					if (age!=-1)
					{
						INode *node = epobj->GetParticleGroup(pid);
						Point3 *curval = epobj->GetParticlePositionByIndex(pid);
						Point3 *curvel = epobj->GetParticleSpeedByIndex(pid);

						Point3 p = *curval * itm;
						Point3 v = *curvel;
						v = VectorTransform(itm,v);
						TempList.Append(1,&p,1);
						VelList.Append(1,&v,1);
						
					}
				}

			}
			else
			{
				particles = (SimpleParticle*) pos.obj;
				particles->Update(t,ParticleNode);

				for (int j=0; j<particles->parts.Count(); j++) {
					if (particles->parts.ages[j] >= 0) 
						{
						Point3 p = particles->parts[j] * itm;
						Point3 v = particles->parts.vels[j];
	//					v = VectorTransform(ptm,v);
						v = VectorTransform(itm,v);
						TempList.Append(1,&p,1);
						VelList.Append(1,&v,1);
						}
					}
				}
			}
		}

//loop through particles transforming them into my space	


//DebugPrint("Frame %d Affect %f\n",t/160,Affect);


  
	AFRDeformer deformer(this);

	os->obj->Deform(&deformer, TRUE);

	os->obj->UpdateValidity(GEOM_CHAN_NUM, LocalValidity(t));

	// Update our user interface parameter
//	UpdateUI(t);

	}

Interval AFRMod::LocalValidity(TimeValue t)
	{
	Interval iv = FOREVER;
	float v;
	Point3 pt;
	pblock->GetValue(PB_STRENGTH,t,v,iv);
	pblock->GetValue(PB_RADIUS,t,v,iv);
	iv.Set(t,t);
	
	return iv;
	}




RefTargetHandle AFRMod::GetReference(int i)
	{
	switch (i) {
		case PBLOCK_REF: return (RefTargetHandle)pblock;
		case PARTICLENODE_REF: return (RefTargetHandle)ParticleNode;
		default: return NULL;
		}
	}

void AFRMod::SetReference(int i, RefTargetHandle rtarg)
	{
	switch (i) {
		case PBLOCK_REF: pblock = (IParamBlock*)rtarg; break;
		case PARTICLENODE_REF: ParticleNode = (INode*)rtarg; break;
		}
	}


Animatable* AFRMod::SubAnim(int i)
	{
	switch (i) {
		case PBLOCK_REF: 		return pblock;
		default: 			return NULL;   
		}
	}

TSTR AFRMod::SubAnimName(int i)
	{

		 return _T(""); 
		
	}

RefResult AFRMod::NotifyRefChanged(
		Interval changeInt,RefTargetHandle hTarget, 
		PartID& partID, RefMessage message)
	{
	switch (message) {
/*		case REFMSG_CHANGE:
			if (editMod==this && pmapParam) pmapParam->Invalidate();
			break;
  */
		case REFMSG_GET_PARAM_DIM: {
			GetParamDim *gpd = (GetParamDim*)partID;
			switch (gpd->index) {
				case PB_STRENGTH: gpd->dim = stdWorldDim; break;
				}
			return REF_STOP; 
			}

		case REFMSG_GET_PARAM_NAME: {
			GetParamName *gpn = (GetParamName*)partID;			
			switch (gpn->index) {
				case PB_STRENGTH: gpn->name = GetString(IDS_AFR_FALLOFF); break;
				}
			return REF_STOP; 
			}

		case REFMSG_CHANGE:	
			{ if (hTarget==ParticleNode); 
			break;
			}
		case REFMSG_TARGET_DELETED:	
			{ if (hTarget==ParticleNode)
				{
				ParticleNode=NULL;
				char t[20];
				strcpy(t,"--None--");
				SendMessage(GetDlgItem(hWnd,IDC_ADD), WM_SETTEXT, 0,(LPARAM) t);

				}
			}
			break;

/*		case REFMSG_TARGET_DELETED: {
			if (hTarget==SelfNode) 
				SelfNode=NULL;
			else if (hTarget==p1) 
				p1=NULL;
			else if (hTarget==pblock) 
				pblock=NULL;
							
			break;
			}
*/

		}
	return REF_SUCCEED;
	}



Point3 AFRDeformer::Map(int i, Point3 p)
	{
	Point3 t(0.0f,0.0f,0.0f);
	if (mod->Remember)
		p = p + mod->DisplaceList[i];

	for (int k=0;k<mod->TempList.Count();k++)
		{
		float d;
		d = Length (p-mod->TempList[k]);
		float percent;
		if (d < mod->Radius)
			{
			if (mod->Curve == 0)  //linear
				percent = (1.0f - (d/mod->Radius));
			else if (mod->Curve == 1) //sinual
				{
				percent = ((float)cos((d/mod->Radius) *  3.14159265359f) + 1.0f)/2.0f;
				}
			else if (mod->Curve == 2) //sinual 1.5
				{
				percent = ((float)cos((d/mod->Radius) *  4.712388980385f) );
//				percent = -((float)cos(((d/mod->Radius)) *  4.712388980385f) - 1.0f);
				}
			else if (mod->Curve == 3) //x^2
				{
				percent = (1.0f - (d/mod->Radius));
				percent = percent * percent;
				}
//			else if (mod->Curve == 4) //x^2
			else
				{
				percent = (1.0f - (d/mod->Radius));
				percent = percent * percent * percent;
				}
			if (mod->Velocity)
				{
				t += mod->VelList[k] * ( percent * mod->Strength);
				if (!mod->x)
					t.x = 0.0f;
				if (!mod->y)
					t.y = 0.0f;
				if (!mod->z)
					t.z = 0.0f;
				}
			else
				{
				Point3 dir(0.0f,0.0f,0.0f);
				dir = p-mod->TempList[k];
				if (!mod->x)
					dir.x = 0.0f;
				if (!mod->y)
					dir.y = 0.0f;
				if (!mod->z)
					dir.z = 0.0f;
				dir = Normalize(dir) * mod->Strength;
				t += dir * percent;
				}
			}
		}
	if (mod->Remember)
		{
		mod->DisplaceList[i] += t;
		p += mod->DisplaceList[i];
		return p;
		}
	else return (p+t); 
	}