/**********************************************************************
 *<
	FILE: skin.cpp

	DESCRIPTION:  Particle Spline

	CREATED BY: Peter Watje

	HISTORY: created May 28, 1997

 *>	Copyright (c) 1997, All Rights Reserved.
 **********************************************************************/
#include "prim.h" 
#include "splshape.h"
#include "iparamm.h"
// This is based on the simple spline object...
#include "..\..\include\simpspl.h"
#include "Simpobj.h"



#define SPLINETYPE 0									 
#define CIRCULAR 0


#define PBLOCK_REF		0
#define SKIN_REF		1


#define MIN_RADIUS		float(0)
#define MAX_RADIUS		float( 1.0E30)

#define DEF_RADIUS		float(0.0)


#define SKIN_ID 0x16f73a7a, 0x6f0d376b



class SegmentType
	{
	public:
	int a,b;
	int used;
	};


class SplineListClass
	{
public:
	INode *SplineNode;
	};




class DonutObjCreateCallBack;

class DonutObject: public ShapeObject, public IParamArray {			   

	friend class DonutObjCreateCallBack;
	
	public:
		// Class vars
		static IParamMap *pmapParam;
		static IObjParam *ip;

		static int splinetype;
		static int circular;
		int NodeCount;

		IParamBlock *pblock;	// User's parameter block
		BezierShape shape;
		Interval ivalid;

		HWND hWnd;

		Tab<Point3> VertList;
		Tab<SegmentType> SegmentList;

		SplineListClass SkinNode[1];


		int GetPointIndex(Point3 point);


		
		void BuildSkin(TimeValue t,BezierShape& ashape); 
		void BuildShape(TimeValue t,BezierShape& ashape);
		
		Interval ObjectValidity(TimeValue t);


		DonutObject();
		~DonutObject();
		void DeleteThis() { delete this; }
		//  inherited virtual methods:

		CreateMouseCallBack* GetCreateMouseCallBack();
		void BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev);
		void EndEditParams( IObjParam *ip, ULONG flags,Animatable *next);
		TCHAR *GetObjectName() { return GetString(IDS_TH_DONUT); }
		void InitNodeName(TSTR& s) { s = GetString(IDS_TH_DONUT); }		
		Class_ID ClassID() { return Class_ID(SKIN_ID); }  
		void GetClassName(TSTR& s) { s = TSTR(GetString(IDS_TH_DONUT)); }
		RefTargetHandle Clone(RemapDir& remap = NoRemap());
		BOOL ValidForDisplay(TimeValue t);

		ParamDimension *GetParameterDim(int pbIndex);
		TSTR GetParameterName(int pbIndex);

		void InvalidateUI() { if (pmapParam) pmapParam->Invalidate(); }



	// ReferenceMaker methods:

		int NumSubs() {return 1;}
		Animatable* SubAnim(int i) {return pblock;}
		TSTR SubAnimName(int i) {return _T("");}

		int NumRefs() {return 1+1;}
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);
		RefResult NotifyRefChanged( Interval changeInt,RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message);


		int NumberOfCurves();
		BOOL CurveClosed(TimeValue t, int curve);

		Point3 InterpCurve3D(TimeValue t, int curve, float param, int ptype=PARAM_SIMPLE);
		Point3 TangentCurve3D(TimeValue t, int curve, float param, int ptype=PARAM_SIMPLE);
		float LengthOfCurve(TimeValue t, int curve);
		int NumberOfPieces(TimeValue t, int curve);
		Point3 InterpPiece3D(TimeValue t, int curve, int piece, float param, int ptype=PARAM_SIMPLE);
		Point3 TangentPiece3D(TimeValue t, int curve, int piece, float param, int ptype=PARAM_SIMPLE);

		ShapeHierarchy &OrganizeCurves(TimeValue t, ShapeHierarchy *hier=NULL);	// Ready for lofting, extrusion, etc.
		void MakePolyShape(TimeValue t, PolyShape &shape, int steps = PSHAPE_BUILTIN_STEPS, BOOL optimize = FALSE);

		int MakeCap(TimeValue t, MeshCapInfo &capInfo, int capType);	// Makes a cap out of the shape
		int MakeCap(TimeValue t, PatchCapInfo &capInfo);

		void ShapeInvalid() { ivalid.SetEmpty(); }
		void UpdateShape(TimeValue t);


		
		ObjectState Eval(TimeValue time);
		int CanConvertToType(Class_ID obtype);
		Object* ConvertToType(TimeValue t, Class_ID obtype);
		void GetCollapseTypes(Tab<Class_ID> &clist,Tab<TSTR*> &nlist);

		void BuildMesh(TimeValue t, Mesh &mesh);
		
		// From ShapeObject
		ObjectHandle CreateTriObjRep(TimeValue t);  // for rendering, also for deformation		
		void GetWorldBoundBox(TimeValue t, INode* inode, ViewExp* vpt, Box3& box );
		void GetLocalBoundBox(TimeValue t, INode* inode, ViewExp* vxt, Box3& box );
		void GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel );
		int NumberOfVertices(TimeValue t, int curve);



		// From BaseObject
		int HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt);
		void Snap(TimeValue t, INode* inode, SnapInfo *snap, IPoint2 *p, ViewExp *vpt);
		int Display(TimeValue t, INode* inode, ViewExp *vpt, int flags);
		void FreeCaches(); 

		// IO
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);


	};				

//------------------------------------------------------

class DonutObjClassDesc:public ClassDesc {
	public:
	int 			IsPublic() { return 1; }
	void *			Create(BOOL loading = FALSE) { return new DonutObject; }
	const TCHAR *	ClassName() { return GetString(IDS_TH_DONUT); }
	SClass_ID		SuperClassID() { return SHAPE_CLASS_ID; }
   	Class_ID		ClassID() { return Class_ID(SKIN_ID); }
	const TCHAR* 	Category() { return GetString(IDS_TH_SPLINES);  }
	void			ResetClassParams(BOOL fileReset);
	};

static DonutObjClassDesc donutObjDesc;

ClassDesc* GetDonutDesc() { return &donutObjDesc; }

// in prim.cpp  - The dll instance handle
extern HINSTANCE hInstance;

// class variable for donut class.
IParamMap *DonutObject::pmapParam  = NULL;
IObjParam *DonutObject::ip         = NULL;
int	 DonutObject::splinetype = SPLINETYPE;

void DonutObjClassDesc::ResetClassParams(BOOL fileReset)
	{
	}



// Vector length for unit circle
#define CIRCLE_VECTOR_LENGTH 0.5517861843f



//--- Parameter map/block descriptors -------------------------------

static int outputIDs[] = {IDC_RADIO1,IDC_RADIO2,IDC_RADIO3,IDC_RADIO4};


#define PB_SPLINETYPE	0
#define PB_MULTIPLE_SPLINES	1
#define PB_MULTIPLE_SPLINES_COUNT	2


//
//
// Parameters


static ParamUIDesc descParam[] = {
	// Spline type
	ParamUIDesc(PB_SPLINETYPE,TYPE_RADIO,outputIDs,4),
	
/*		
	// USe multple spline
	ParamUIDesc(PB_MULTIPLE_SPLINES,TYPE_SINGLECHEKBOX,IDC_MULTIPLE_SPLINES),

		
	// Knots per spline
	ParamUIDesc(
		PB_MULTIPLE_SPLINES_COUNT,
		EDITTYPE_INT,
		IDC_KNOTS_PER_SPLINE,IDC_KNOTS_PER_SPLINE_SPINNER,
		1.0f,999999999.0f,
		1.0f),
  */

	};
#define PARAMDESC_LENGTH 1



static ParamBlockDescID descVer0[] = {
	{ TYPE_FLOAT, NULL, TRUE, 0 },
	{ TYPE_INT, NULL, TRUE, 1 },
	{ TYPE_INT, NULL, FALSE, 2 },
	{ TYPE_INT, NULL, FALSE, 3 },
	{ TYPE_INT, NULL, FALSE, 4 } };

static ParamBlockDescID descVer1[] = {
	{ TYPE_FLOAT, NULL, TRUE, 0 },
	{ TYPE_INT, NULL, TRUE, 1 },
	{ TYPE_INT, NULL, FALSE, 2 },
	{ TYPE_INT, NULL, FALSE, 3 },
	{ TYPE_INT, NULL, FALSE, 4 },
	{ TYPE_INT, NULL, FALSE, 5 } };

static ParamBlockDescID descVer2[] = {
	{ TYPE_INT, NULL, TRUE, 0 },
	 };

static ParamBlockDescID descVer3[] = {
	{ TYPE_INT, NULL, TRUE, 0 },
//	{ TYPE_INT, NULL, FALSE, 0 },
//	{ TYPE_INT, NULL, FALSE, 0 },
	 };

#define PBLOCK_LENGTH	1

// Array of old versions
static ParamVersionDesc versions[] = {
	ParamVersionDesc(descVer0,5,4),
	ParamVersionDesc(descVer1,6,5),	
	ParamVersionDesc(descVer2,1,6)	
	};
#define NUM_OLDVERSIONS	3

// Current version
#define CURRENT_VERSION	7
static ParamVersionDesc curVersion(descVer3,PBLOCK_LENGTH,CURRENT_VERSION);





//This handles the output of particle info
//Hit Dialog

class DumpHitDialog : public HitByNameDlgCallback {
public:
	DonutObject *eo;
	DumpHitDialog(DonutObject *e) {eo=e;};
	TCHAR *dialogTitle() {return _T("Select skin sections");};
	TCHAR *buttonText() {return _T("Select");};
	BOOL singleSelect() {return FALSE;};
	BOOL useProc() {return TRUE;};
	int filter(INode *node);
	void proc(INodeTab &nodeTab);
	};

void DumpHitDialog::proc(INodeTab &nodeTab)

{

//?

	SplineListClass t;


	t.SplineNode = nodeTab[0];
	eo->ReplaceReference(SKIN_REF,nodeTab[0]);
	SetWindowText(GetDlgItem(eo->hWnd,IDC_NAME),
			eo->SkinNode[0].SplineNode->GetName());


	TCHAR title[200];
	_tcscpy(title,nodeTab[0]->GetName());

//	SendMessage(GetDlgItem(eo->hWnd,IDC_LIST1),
//		LB_ADDSTRING,0,(LPARAM)(TCHAR*)title);

/*
ModContextList mcList;
INodeTab nodes;
eo->ip->GetModContexts(mcList,nodes);
if ( (nodes.Count()>0) && 
	 (nodeTab.Count()>0)  ) {
	Matrix3 tm;
 	tm = nodeTab[0]->GetObjectTM(0);
	nodes[0]->SetNodeTM(0, tm);
//	ourTM = nodes[0]->GetObjectTM(ip->GetTime());
	}
*/
eo->ShapeInvalid();

eo->NotifyDependents(FOREVER, TOPO_CHANNEL, REFMSG_CHANGE);
											
}





int DumpHitDialog::filter(INode *node)

{
	ObjectState os = node->EvalWorldState(eo->ip->GetTime());
//filter only particle objects
	if (os.obj->GetInterface(I_PARTICLEOBJ)==NULL)
		return FALSE;
		else return TRUE;

}


//-- SkinDlgProc ------------------------------------------------

class SkinDlgProc : public ParamMapUserDlgProc {
	public:
		DonutObject *po;
		HWND TempHWND;

		SkinDlgProc(DonutObject *p) {
			po=p;
			}
		BOOL DlgProc(TimeValue t,IParamMap *map,HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
		void DeleteThis() {
			delete this;
			}
		void DumpRPS(HWND hWnd);

	};

void SkinDlgProc::DumpRPS(HWND hWnd)
	{
//pick nodes to apply motion to 
	po->ip->DoHitByNameDialog(new DumpHitDialog(po));
	}


BOOL SkinDlgProc::DlgProc(
		TimeValue t,IParamMap *map,HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
	{
	switch (msg) {
		case WM_INITDIALOG:
			{
			po->hWnd = hWnd;
			
			po->NodeCount = 0;

			if (po->SkinNode[0].SplineNode!=NULL)
				{

				SetWindowText(GetDlgItem(po->hWnd,IDC_NAME),
					po->SkinNode[0].SplineNode->GetName());
				}

//add names here
			break;			
			}
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDC_ADD :
					DumpRPS(hWnd);
					break;
				}
			break;	
		}
	return FALSE;
	}






void DonutObject::BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev )
	{
	this->ip = ip;
	ShapeObject::BeginEditParams(ip, flags, prev);

	if ( pmapParam) {
		
		// Left over from last donut ceated
		pmapParam->SetParamBlock(pblock);
	} else {
		
		// Gotta make a new one.

		pmapParam = CreateCPParamMap(
			descParam,PARAMDESC_LENGTH,
			pblock,
			ip,
			hInstance,
			MAKEINTRESOURCE(IDD_DONUTPARAM2),
			GetString(IDS_TH_PARAMETERS),
			0);

		
		}

	pmapParam->SetUserDlgProc(new SkinDlgProc(this));

	}
		
void DonutObject::EndEditParams( IObjParam *ip,ULONG flags,Animatable *next )
	{
	this->ip = NULL;
	ShapeObject::EndEditParams(ip,flags,next);
	if (flags&END_EDIT_REMOVEUI ) {
		DestroyCPParamMap(pmapParam);
		pmapParam  = NULL;
		}

	// Save these values in class variables so the next object created will inherit them.
	}


RefTargetHandle DonutObject::GetReference(int i) 
	{
	switch (i) {
		case PBLOCK_REF:	return pblock;	
		case SKIN_REF :		return SkinNode[0].SplineNode;
		default : return NULL;
/*		default : {
				if (i<100)
					return SkinNode[i-1].SplineNode;
					else return 
						SkinControl[i-101].c;
				}
*/
		}
	}

void DonutObject::SetReference(int i, RefTargetHandle rtarg) 
	{	
	switch (i) {
		case PBLOCK_REF: pblock = (IParamBlock*)rtarg; break;
		case SKIN_REF:SkinNode[0].SplineNode = (INode*)rtarg; break;

		}
	}


RefResult DonutObject::NotifyRefChanged(
		Interval changeInt, RefTargetHandle hTarget,
		PartID& partID,  RefMessage message) 

	{
		{
		switch (message) {
			case REFMSG_CHANGE:
				ShapeInvalid();
				ivalid.SetEmpty();
				if (ip) {
					InvalidateUI();
					}
				break;

			case REFMSG_TARGET_DELETED: {
				if (hTarget==pblock) {
					pblock = NULL;					
					}
				else {
					if (hTarget==SkinNode[0].SplineNode) {
							SkinNode[0].SplineNode=NULL;
							}
						
					}

				break;
				}

/*			case REFMSG_GET_PARAM_DIM: {
				GetParamDim *gpd = (GetParamDim*)partID;
				gpd->dim = GetParameterDim(gpd->index);			
				return REF_STOP; 
				}

			case REFMSG_GET_PARAM_NAME: {
				GetParamName *gpn = (GetParamName*)partID;
				gpn->name = GetParameterName(gpn->index);			
				return REF_STOP; 
				}
*/		
			}
		}
	return REF_SUCCEED;
	}





int DonutObject::GetPointIndex(Point3 point)
{
for (int i=0;i<VertList.Count();i++)
	{
	if (VertList[i] == point)
		return i;
	}
return 0;
};


void DonutObject::BuildSkin(TimeValue t,BezierShape& ashape) {






//SplineShape *shape = (SplineShape *)os->obj;

//Add extra spline info here

//object inv tm


 


TimeValue Smallest;
Smallest = 99999999;
Tab<int> Used;
int K = 0,KType;
int UseMSpline=0,MSplineCount = 0;
pblock->GetValue(PB_SPLINETYPE,t,K,FOREVER);

//pblock->GetValue(PB_MULTIPLE_SPLINES,t,UseMSpline,FOREVER);
//pblock->GetValue(PB_MULTIPLE_SPLINES_COUNT,t,MSplineCount,FOREVER);

if (K == 0)
		KType = KTYPE_CORNER;
else if (K == 1)
		KType = KTYPE_AUTO;
else if (K == 2)
		KType = KTYPE_BEZIER;
else if (K == 3)
		KType = KTYPE_BEZIER_CORNER;



if (SkinNode[0].SplineNode != NULL)
	{
	SimpleParticle *particles;

	ObjectState os = SkinNode[0].SplineNode->EvalWorldState(t);

	Matrix3 tm, invtm;
	tm    = SkinNode[0].SplineNode->GetObjTMAfterWSM(t);
//	tm = *mc.tm;
	invtm = Inverse(tm);

//	particles->valid = FALSE;
	particles = (SimpleParticle*) os.obj;

	int Active = 0;
	for (int j=0; j<particles->parts.Count(); j++) {
		int u = 0;
		Used.Append(1,&u,1);
		if (particles->parts.ages[j] >= 0) 
			Active++;

		}

    if (Active >= 2)
		{

		int Done = 0;
		int First = 0;
		Point3 StartVert;
		Spline3D* NewSpline;
//get spline tm
		int KnotCount = 0;

		while (!Done)
			{
			if (KnotCount == 0)
				{
				NewSpline = ashape.NewSpline(KTYPE_CORNER,KTYPE_BEZIER);
				NewSpline->SetOpen();
				}

			if (UseMSpline)
				{
				if (KnotCount == MSplineCount)
					KnotCount = 0;
				}


			int CKnot=-1;
			Smallest = 99999999;
			for (int j=0; j<particles->parts.Count(); j++) {
				if ((particles->parts.ages[j] >= 0) && (!Used[j]))
					{
					 if (particles->parts.ages[j] < Smallest)
						{
						 Smallest = particles->parts.ages[j];
						 CKnot = j;
						}
					}
				}
			if (CKnot != -1)
				{
				Used[CKnot] = 1;
				if (First == 0)
					{
					StartVert = particles->parts.points[CKnot];
					}
//add spline knot
				Point3 KnotVert = particles->parts.points[CKnot]*invtm;
				SplineKnot kn(KType,LTYPE_CURVE,KnotVert,KnotVert,KnotVert);
				NewSpline->AddKnot(kn);
				KnotCount++;

				}
			else
				Done = 1;
			First++;

			}
		NewSpline->ComputeBezPoints();
		for (int poly=0;poly<NewSpline->KnotCount();poly++)
				NewSpline->SetKnotType(poly,KType);
		NewSpline->ComputeBezPoints();


		}
	}
else
	{
	Spline3D* NewSpline;
	NewSpline = ashape.NewSpline(KTYPE_CORNER,KTYPE_BEZIER);
	}
}



void DonutObject::BuildShape(TimeValue t, BezierShape& ashape) {
	// Start the validity interval at forever and whittle it down.
	ivalid = FOREVER;


	if (SkinNode[0].SplineNode != NULL)
			SkinNode[0].SplineNode->GetNodeTM(t,&ivalid);


	ashape.NewShape();
	
	BuildSkin(t, ashape);

//	MakeCircle(ashape,radius2);

	ashape.UpdateSels();	// Make sure it readies the selection set info
	ashape.InvalidateGeomCache();

	
	ivalid.Set(t,t);
	NotifyDependents(FOREVER, TOPO_CHANNEL, REFMSG_CHANGE);

//	ivalid.SetEmpty();


	}



DonutObject::DonutObject() 
	{
//	ReadyInterpParameterBlock();		// Build the interpolations parameter block in SimpleSpline
	MakeRefByID(FOREVER, PBLOCK_REF, CreateParameterBlock(descVer3, PBLOCK_LENGTH, CURRENT_VERSION));
	assert(pblock);
	SkinNode[0].SplineNode = NULL;	
	
 	}

DonutObject::~DonutObject()
	{
	SkinNode[0].SplineNode = NULL;	
	DeleteAllRefsFromMe();
	pblock = NULL;
	}

class DonutObjCreateCallBack: public CreateMouseCallBack {
	DonutObject *ob;
	Point3 p[3];
	IPoint2 sp0;
	Point3 center;
	int createType;
	public:
		int proc( ViewExp *vpt,int msg, int point, int flags, IPoint2 m, Matrix3& mat );
		void SetObj(DonutObject *obj) { ob = obj; }
	};

int DonutObjCreateCallBack::proc(ViewExp *vpt,int msg, int point, int flags, IPoint2 m, Matrix3& mat ) {
	if (msg==MOUSE_POINT||msg==MOUSE_MOVE) {
		switch(point) {
/*
			case 0:
				ob->suspendSnap = TRUE;
				sp0 = m;
				createType = 1;
				p[0] = vpt->SnapPoint(m,m,NULL,SNAP_IN_PLANE);
				mat.SetTrans(p[0]); // Set Node's transform
				ob->pblock->SetValue(PB_RADIUS1,0,0.01f);
				ob->pmapParam->Invalidate();
				break;
			case 1: 
				p[1] = vpt->SnapPoint(m,m,NULL,SNAP_IN_PLANE);
				if ( createType ) {	// radius	
					r = Length(p[1]-p[0]);
					center = p[0];
					}
				else {// diameter
					center = (p[0]+p[1]) / 2.0f;
					r = Length(center-p[0]);
					mat.SetTrans(center);  // Modify Node's transform
					}
				ob->pblock->SetValue(PB_RADIUS1,0,r);
				ob->pmapParam->Invalidate();
				if (msg==MOUSE_POINT) {
					if(Length(m-sp0)<3 || Length(p[1]-p[0])<0.1f) {
						return CREATE_ABORT;
						}
					}
				break;
*/
			case 0:
				p[0] = vpt->SnapPoint(m,m,NULL,SNAP_IN_PLANE);
				mat.SetTrans(p[0]); // Set Node's transform

				ob->pmapParam->Invalidate();
				return CREATE_STOP;
				break;
			}
		}
	else
	if (msg == MOUSE_ABORT) {
		return CREATE_ABORT;
		}

	ob->ShapeInvalid();
	ob->NotifyDependents(FOREVER, PART_OBJ, REFMSG_CHANGE);

	return TRUE;
	}

static DonutObjCreateCallBack donutCreateCB;

CreateMouseCallBack* DonutObject::GetCreateMouseCallBack() {
	donutCreateCB.SetObj(this);
	return(&donutCreateCB);
	}

RefTargetHandle DonutObject::Clone(RemapDir& remap) {
	DonutObject* newob = new DonutObject();
	CopyBaseData(*this);
	newob->ReplaceReference(PBLOCK_REF,pblock->Clone(remap));	
	newob->ivalid.SetEmpty();	
	BaseClone(this, newob, remap);
	return(newob);
	}

BOOL DonutObject::ValidForDisplay(TimeValue t) {
//	float radius1, radius2;
//	pblock->GetValue(PB_RADIUS1, t, radius1, ivalid);
//	pblock->GetValue(PB_RADIUS2, t, radius2, ivalid);
//	return (radius1 == 0.0f && radius2 == 0.0f) ? FALSE : TRUE;
	return TRUE;
	}

ParamDimension *DonutObject::GetParameterDim(int pbIndex) 
	{
/*	switch (pbIndex) {

		case PB_RADIUS1:
		case PB_RADIUS2:

			return stdWorldDim;			
*/
//		default:
			return defaultDim;
//		}
	}

TSTR DonutObject::GetParameterName(int pbIndex) 
	{
	switch (pbIndex) {

		case PB_SPLINETYPE:
			return TSTR(_T("SplineType"));
/*		case PB_RADIUS2:
			return TSTR(GetString(IDS_TH_RADIUS2));
*/
		default:
			return TSTR(_T(""));
		}								 
	}

Interval DonutObject::ObjectValidity(TimeValue t)
	{		
	Interval valid = FOREVER;
//	valid = GetValidity(t);	
	if (SkinNode[0].SplineNode != NULL)
			SkinNode[0].SplineNode->GetNodeTM(t,&ivalid);
	valid.Set(t,t);
	return valid;
	}




ObjectState DonutObject::Eval(TimeValue time) 
	{
	return ObjectState(this);
	}

int DonutObject::NumberOfCurves() {
	UpdateShape(GetCOREInterface()->GetTime());
	return shape.splineCount;
	}


BOOL DonutObject::CurveClosed(TimeValue t, int curve) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.splines[curve]->Closed() ? TRUE : FALSE;
	}



Point3 DonutObject::InterpCurve3D(TimeValue t, int curve, float param, int ptype) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.InterpCurve3D(curve, param, ptype);
	}

Point3 DonutObject::TangentCurve3D(TimeValue t, int curve, float param, int ptype) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.TangentCurve3D(curve, param, ptype);
	}

float DonutObject::LengthOfCurve(TimeValue t, int curve) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.LengthOfCurve(curve);
	}

int DonutObject::NumberOfPieces(TimeValue t, int curve) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.splines[curve]->Segments();
	}

Point3 DonutObject::InterpPiece3D(TimeValue t, int curve, int piece, float param, int ptype) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.InterpPiece3D(curve, piece, param, ptype);
	}

Point3 DonutObject::TangentPiece3D(TimeValue t, int curve, int piece, float param, int ptype) {
	UpdateShape(t);
	if(curve < 0 || curve >= shape.splineCount)
		assert(0);
	return shape.TangentPiece3D(curve, piece, param, ptype);
	}



ShapeHierarchy &DonutObject::OrganizeCurves(TimeValue t, ShapeHierarchy *hier) {
	UpdateShape(t);
	return shape.OrganizeCurves(t, hier);
	}

// Hand back a custom PolyShape representation of this shape!
void DonutObject::MakePolyShape(TimeValue t, PolyShape &shape, int steps, BOOL optimize) {
	UpdateShape(t);
	this->shape.MakePolyShape(shape, steps, optimize);
	}




// Cap this shape
int DonutObject::MakeCap(TimeValue t, MeshCapInfo &capInfo, int capType) {
	UpdateShape(t);
	return shape.MakeCap(t, capInfo, capType);
	}

int DonutObject::MakeCap(TimeValue t, PatchCapInfo &capInfo) {
	UpdateShape(t);
	return shape.MakeCap(t, capInfo);
	}


void DonutObject::UpdateShape(TimeValue t) {
	if ( ivalid.InInterval(t) )
		return;
	BuildShape(t, shape);
	}


void DonutObject::FreeCaches() {
	ivalid.SetEmpty();
	shape.NewShape();
	}




int DonutObject::NumberOfVertices(TimeValue t, int curve) {
	UpdateShape(t);
	if(curve >= shape.splineCount)
		assert(0);
	if(curve >= 0)
		return shape.splines[curve]->KnotCount();
	int verts = 0;
	for(int i = 0; i < shape.splineCount; ++i)
		verts += shape.splines[i]->KnotCount();
	return verts;
	}



int DonutObject::CanConvertToType(Class_ID obtype) {
	if ( obtype == splineShapeClassID ||obtype == genericShapeClassID
        )
        {
		return 1;
		}
	if (Object::CanConvertToType (obtype)) return 1;
	if (CanConvertTriObject (obtype)) return 1;
	return 0;
	}

extern TCHAR *GetString(int id);

void DonutObject::GetCollapseTypes(Tab<Class_ID> &clist,Tab<TSTR*> &nlist)
{
    Object::GetCollapseTypes(clist, nlist);
}

Object* DonutObject::ConvertToType(TimeValue t, Class_ID obtype) {
	if (obtype == splineShapeClassID || obtype == defObjectClassID || obtype == genericShapeClassID) {
		UpdateShape(t);
		SplineShape *bshape = new SplineShape();	
		theHold.Suspend();
		bshape->CopyBaseData(*this);
		theHold.Resume();
		bshape->shape = shape;
		bshape->SetChannelValidity(TOPO_CHAN_NUM,ObjectValidity(t));
		bshape->SetChannelValidity(GEOM_CHAN_NUM,ObjectValidity(t));
		return bshape;
		}

	if (Object::CanConvertToType (obtype)) {
		return Object::ConvertToType (t, obtype);
	}

	return NULL;
	}

void DonutObject::GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel )
	{
	UpdateShape(t);
	box = shape.GetBoundingBox(tm);
	box += ShapeObject::GetBoundingBox(t, tm);
	}

void DonutObject::GetLocalBoundBox(TimeValue t, INode *inode,ViewExp* vpt,  Box3& box ) {
	UpdateShape(t);
	box = shape.GetBoundingBox();
	box += ShapeObject::GetBoundingBox(t);
	}

void DonutObject::GetWorldBoundBox(TimeValue t, INode *inode, ViewExp* vpt, Box3& box )
	{
	Matrix3 mat = inode->GetObjectTM(t);
	UpdateShape(t);
	box = shape.GetBoundingBox();
	box += ShapeObject::GetBoundingBox(t);
	box = box * mat;
	}


// From BaseObject

int DonutObject::HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt) {	
	HitRegion hitRegion;
	GraphicsWindow *gw = vpt->getGW();	
	Material *mtl = gw->getMaterial();
   	
	UpdateShape(t);
	gw->setTransform(inode->GetObjectTM(t));

	MakeHitRegion(hitRegion, type, crossing, 4, p);
	return shape.Select( gw, mtl, &hitRegion, flags & HIT_ABORTONHIT );
	}

void DonutObject::Snap(TimeValue t, INode* inode, SnapInfo *snap, IPoint2 *p, ViewExp *vpt) {

	Matrix3 tm = inode->GetObjectTM(t);	
	GraphicsWindow *gw = vpt->getGW();	
   	
	UpdateShape(t);
	gw->setTransform(tm);

	shape.Snap( gw, snap, p, tm );
	}

#define DISP_NODEFAULTCOLOR (1<<12)
#define COMP_NODEFAULTCOLOR (1<<10)

int DonutObject::Display(TimeValue t, INode *inode, ViewExp *vpt, int flags) {
	if ( !ValidForDisplay(t) )
		return 0;

	GraphicsWindow *gw = vpt->getGW();

   	UpdateShape(t);
	gw->setTransform(inode->GetObjectTM(t));
	
	ShapeObject::Display(t, inode, vpt, flags);

	// If creating, show the vertex ticks
	BOOL ticksSet = FALSE;

	shape.Render( gw, inode->Mtls(),
		(flags&USE_DAMAGE_RECT) ? &vpt->GetDammageRect() : NULL, 
		COMP_ALL | ((flags&DISP_SHOWSUBOBJECT)?COMP_OBJSELECTED:0) |
		((flags&DISP_NODEFAULTCOLOR)?COMP_NODEFAULTCOLOR:0) 
		, inode->NumMtls());

	// Turn off the ticks if we set 'em
	if(ticksSet)
		shape.dispFlags &= ~DISP_VERTTICKS;

	return(0);
	}


// From GeomObject

ObjectHandle DonutObject::CreateTriObjRep(TimeValue t) {
	TriObject *tri = new TriObject;
	BuildMesh(t,tri->GetMesh());
	return(ObjectHandle(tri));
	}

void DonutObject::BuildMesh(TimeValue t, Mesh &mesh) {
	UpdateShape(t);		// Get the shape
	// If the ShapeObject is set to display the generated mesh, use it!
	if(GetDispRenderMesh()) {
		GenerateMesh(t, -1, &mesh);
		return;
		}
	PolyShape pShape;
	MakePolyShape(t, pShape);
	ShapeHierarchy hier;
	pShape.OrganizeCurves(t, &hier);
	// Need to flip the reversed curves in the shape!
	pShape.Reverse(hier.reverse);
	int verts = 0;
	int polys = pShape.numLines;
	for(int poly = 0; poly < polys; ++poly)
		verts += pShape.lines[poly].numPts;
	mesh.setNumVerts(verts);
	verts = 0;
	for(poly = 0; poly < polys; ++poly) {
		PolyLine &line = pShape.lines[poly];
		for(int j = 0; j < line.numPts; ++j) {
			mesh.setVert(verts++, line.pts[j].p);
			}
		}
	MeshCapInfo capInfo;
	pShape.MakeCap(t, capInfo, CAPTYPE_MORPH);
	MeshCapper capper(pShape);
	int vert = 0;
	for(poly = 0; poly < polys; ++poly) {
		PolyLine &line = pShape.lines[poly];
		MeshCapPoly &capline = capper[poly];
		int lverts = line.numPts;
		for(int v = 0; v < lverts; ++v)
			capline.SetVert(v, vert++);			// Gives this vert's location in the mesh!
		}
	capper.CapMesh(mesh, capInfo, FALSE, 1);
	}


IOResult DonutObject::Save(ISave *isave) 
	{
	IOResult res = ShapeObject::Save(isave);
	shape.Save(isave);
	return IO_OK;
	}

IOResult DonutObject::Load(ILoad *iload) 
	{
	IOResult res = ShapeObject::Load(iload);
	shape.Load(iload);
	return res;;
	}