/**********************************************************************
 *<
	FILE: simpspl.h

	DESCRIPTION:  Defines a simple spline object class to make spline
		primitives easier to create

	CREATED BY: Tom Hudson

	HISTORY: created 3 October 1995

 *>	Copyright (c) 1995, All Rights Reserved.
 **********************************************************************/

#ifndef __SIMPSPL_H__ 

#define __SIMPSPL_H__

// Interpolation parameter block indices
#define IPB_STEPS		0
#define IPB_OPTIMIZE	1
#define IPB_ADAPTIVE	2

// Parameter block reference indices
#define USERPBLOCK 0	// User's parameter block
#define IPBLOCK 1		// Interpolations parameter block

// Default interpolation settings
#define DEF_STEPS 6
#define DEF_OPTIMIZE TRUE
#define DEF_ADAPTIVE FALSE

// Special dialog handling
class SimpleSpline;

class SimpleSplineDlgProc : public ParamMapUserDlgProc {
	private:
		SimpleSpline *spl;
	public:
		SimpleSplineDlgProc(SimpleSpline *s) { spl = s; }
		BOOL DlgProc(TimeValue t,IParamMap *map,HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
		void DeleteThis() { delete this; }
		void MaybeDisableControls(HWND hWnd);
	};
						 
class SimpleSpline: public ShapeObject {			   
	private:
	public:
		IParamBlock *ipblock;	// Interpolation parameter block (handled by SimpleSpline)
		IParamBlock *pblock;	// User's parameter block

		static IParamMap *ipmapParam;
		static int dlgSteps;
		static BOOL dlgOptimize;
		static BOOL dlgAdaptive;

		// Spline cache
		BezierShape shape;
		Interval ivalid;

		// Flag to suspend snapping -- Used during creation
		BOOL suspendSnap;

		void UpdateShape(TimeValue t);

		static SimpleSpline *editOb;

		SimpleSpline();
		~SimpleSpline();

		void ShapeInvalid() { ivalid.SetEmpty(); }

		//  inherited virtual methods:

		// From BaseObject
		int HitTest(TimeValue t, INode* inode, int type, int crossing, int flags, IPoint2 *p, ViewExp *vpt);
		void Snap(TimeValue t, INode* inode, SnapInfo *snap, IPoint2 *p, ViewExp *vpt);
		int Display(TimeValue t, INode* inode, ViewExp *vpt, int flags);
		virtual void BeginEditParams( IObjParam *ip, ULONG flags,Animatable *prev);
		IParamArray *GetParamBlock() {return pblock;}
		int GetParamBlockIndex(int id);

		// From Object
		ObjectState Eval(TimeValue time);
		Interval ObjectValidity(TimeValue t);
		int CanConvertToType(Class_ID obtype);
		Object* ConvertToType(TimeValue t, Class_ID obtype);
		void BuildMesh(TimeValue t, Mesh &mesh);
		
		// From ShapeObject
		int IntersectRay(TimeValue t, Ray& r, float& at);
		ObjectHandle CreateTriObjRep(TimeValue t);  // for rendering, also for deformation		
		void GetWorldBoundBox(TimeValue t, INode* inode, ViewExp* vpt, Box3& box );
		void GetLocalBoundBox(TimeValue t, INode* inode, ViewExp* vxt, Box3& box );
		void GetDeformBBox(TimeValue t, Box3& box, Matrix3 *tm, BOOL useSel );
		int IsRenderable();
		int NumberOfCurves();
		BOOL CurveClosed(TimeValue t, int curve);
		Point3 InterpCurve3D(TimeValue t, int curve, float param);
		Point3 TangentCurve3D(TimeValue t, int curve, float param);
		float LengthOfCurve(TimeValue t, int curve);
		int NumberOfPieces(TimeValue t, int curve);
		Point3 InterpPiece3D(TimeValue t, int curve, int piece, float param);
		Point3 TangentPiece3D(TimeValue t, int curve, int piece, float param);
		BOOL CanMakeBezier() { return TRUE; }			// Return TRUE if can turn into a bezier representation
		void MakeBezier(TimeValue t, BezierShape &shape);	// Create the bezier representation
		ShapeHierarchy &OrganizeCurves(TimeValue t, ShapeHierarchy *hier=NULL);	// Ready for lofting, extrusion, etc.
		void MakePolyShape(TimeValue t, PolyShape &shape, int steps = PSHAPE_BUILTIN_STEPS, BOOL optimize = FALSE);
		int MakeCap(TimeValue t, MeshCapInfo &capInfo, int capType);	// Makes a cap out of the shape
		int MakeCap(TimeValue t, PatchCapInfo &capInfo);

		int NumRefs() {return 2;}
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);		
		RefResult NotifyRefChanged(Interval changeInt,RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message);

		void ReadyInterpParameterBlock();
		void UnReadyInterpParameterBlock() { ipblock = NULL; }

		void SimpleSplineClone( SimpleSpline *ssplSource );

 		int NumSubs() { return 2; }  
		Animatable* SubAnim(int i);
		TSTR SubAnimName(int i);		

		// Animatable methods
		void DeleteThis() { delete this; }
		void FreeCaches(); 

		// IO
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);

		LRESULT CALLBACK TrackViewWinProc( HWND hwnd,  UINT message, 
	            WPARAM wParam,   LPARAM lParam ){return(0);}

		// Clients of SimpleSpline need to implement these methods:
	
		virtual TCHAR *GetObjectName() = 0;
		virtual void InitNodeName(TSTR& s) = 0;
		virtual Class_ID ClassID() = 0;
		virtual void GetClassName(TSTR& s) = 0;
		virtual void BuildShape(TimeValue t,BezierShape& ashape) = 0;
		virtual RefTargetHandle Clone(RemapDir& remap = NoRemap()) = 0;
		virtual void EndEditParams( IObjParam *ip, ULONG flags,Animatable *next) = 0;
		virtual CreateMouseCallBack* GetCreateMouseCallBack() = 0;
		virtual BOOL ValidForDisplay(TimeValue t) = 0;
		virtual void InvalidateUI() {}
		virtual	ParamDimension *GetParameterDim(int pbIndex) {return defaultDim;}
		virtual TSTR GetParameterName(int pbIndex) {return TSTR(_T("Parameter"));}
		virtual BOOL DisplayVertTicksDuringCreation() { return TRUE; }
	};				

#endif // __SIMPSPL_H__
