/********************************************************************** *<
	FILE: unwrap.cpp

	DESCRIPTION: A UVW map modifier unwraps the UVWs onto the image

	HISTORY: 12/31/96
	CREATED BY: Rolf Berteig
	UPDATED Sept. 16, 1998 Peter Watje




 *>	Copyright (c) 1998, All Rights Reserved.
**********************************************************************/

#include "mods.h"
#include "iparamm.h"
#include "meshadj.h"
#include "decomp.h"

#include "gport.h"
#include "bmmlib.h"

#include "stdmat.h"


#define UNWRAP_NAME		GetString(IDS_RB_UNWRAPMOD)
#define UNWRAP_CLASSID	Class_ID(0x02df2e3a,0x72ba4e21)


class UnwrapMod : public Modifier, TimeChangeCallback {	
	public:	


		int channel;

		static HWND hParams, hWnd;
		static IObjParam  *ip;
		static UnwrapMod *editMod;
		static ISpinnerControl *iMapID;

		UnwrapMod();
		~UnwrapMod();

		// From Animatable
		void DeleteThis() { delete this; }
		void GetClassName(TSTR& s) {s=UNWRAP_NAME;}
		virtual Class_ID ClassID() {return UNWRAP_CLASSID;}
		void BeginEditParams(IObjParam  *ip, ULONG flags,Animatable *prev);
		void EndEditParams(IObjParam *ip,ULONG flags,Animatable *next);		
		TCHAR *GetObjectName() { return UNWRAP_NAME; }
		CreateMouseCallBack* GetCreateMouseCallBack() {return NULL;} 
		BOOL AssignController(Animatable *control,int subAnim);

		ChannelMask ChannelsUsed()  {return PART_GEOM|PART_TOPO|PART_SELECT|PART_SUBSEL_TYPE|PART_VERTCOLOR;}
		ChannelMask ChannelsChanged() {return TEXMAP_CHANNEL|PART_VERTCOLOR; }		
//		Class_ID InputType() {return triObjectClassID;}
		Class_ID InputType() {return mapObjectClassID;}
		void ModifyObject(TimeValue t, ModContext &mc, ObjectState *os, INode *node);
		Interval LocalValidity(TimeValue t);		

		int NumRefs() {
						int ct = 0;
						return ct;
						}
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);

		// From BaseObject
		int Display(TimeValue t, INode* inode, ViewExp *vpt, int flagst, ModContext *mc);


		int NumSubs() {
						int ct = 0;
						return ct;
						}

		Animatable* SubAnim(int i);
		TSTR SubAnimName(int i);
		
		RefTargetHandle Clone(RemapDir& remap = NoRemap());
		RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message);
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);

		// From TimeChangeCallback
		void TimeChanged(TimeValue t) {}
		void SetupChannelButtons();
		void RemoveDeadVerts(Mesh *mesh,int CurrentChannel);
		void RemoveDeadVerts(PatchMesh *mesh,int CurrentChannel);

};




class UnwrapClassDesc:public ClassDesc {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading = FALSE) {return new UnwrapMod;}
	const TCHAR *	ClassName() {return UNWRAP_NAME;}
	SClass_ID		SuperClassID() {return OSM_CLASS_ID;}
	Class_ID		ClassID() {return UNWRAP_CLASSID;}
	const TCHAR* 	Category() {return GetString(IDS_RB_DEFSURFACE);}
	};

static UnwrapClassDesc unwrapDesc;
ClassDesc* GetUnwrapModDesc() {return &unwrapDesc;}


HWND            UnwrapMod::hParams = NULL;
HWND            UnwrapMod::hWnd = NULL;
IObjParam      *UnwrapMod::ip = NULL;
ISpinnerControl *UnwrapMod::iMapID = NULL;
UnwrapMod      *UnwrapMod::editMod = NULL;

//--- UnwrapMod methods -----------------------------------------------

UnwrapMod::UnwrapMod()
	{
	channel = 0;

	}

UnwrapMod::~UnwrapMod()
	{
	DeleteAllRefsFromMe();
	}

static BOOL CALLBACK UnwrapRollupWndProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
	UnwrapMod *mod = (UnwrapMod*)GetWindowLong(hWnd,GWL_USERDATA);
	
	static BOOL inEnter = FALSE;

	switch (msg) {
		case WM_INITDIALOG:
			mod = (UnwrapMod*)lParam;
			SetWindowLong(hWnd,GWL_USERDATA,lParam);
			mod->hParams = hWnd;
			

			mod->iMapID = GetISpinner(GetDlgItem(hWnd,IDC_MAP_CHAN_SPIN));
			mod->iMapID->LinkToEdit(GetDlgItem(hWnd,IDC_MAP_CHAN),EDITTYPE_INT);
			mod->iMapID->SetLimits(1, 99, FALSE);
			mod->iMapID->SetAutoScale();	

			mod->SetupChannelButtons();

			break;


		case CC_SPINNER_BUTTONUP:
				{
				TSTR buf1 = GetString(IDS_RB_SHOULDRESET);
				TSTR buf2 = GetString(IDS_RB_UNWRAPMOD);
				int tempChannel = mod->iMapID->GetIVal();
				if (tempChannel == 1) tempChannel = 0;
				if (tempChannel != mod->channel)
					{
					mod->channel = mod->iMapID->GetIVal();
					if (mod->channel == 1) mod->channel = 0;
					mod->SetupChannelButtons();
					}

				}

			break;


		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDC_MAP_CHAN1:
				case IDC_MAP_CHAN2: {
					TSTR buf1 = GetString(IDS_RB_SHOULDRESET);
					TSTR buf2 = GetString(IDS_RB_UNWRAPMOD);
						{
						mod->channel = IsDlgButtonChecked(hWnd,IDC_MAP_CHAN2);
						if (mod->channel == 1)
							mod->iMapID->Enable(FALSE);
						else 
							{
							int ival = mod->iMapID->GetIVal();
							if (ival == 1) mod->channel = 0;
							  else mod->channel = ival;
							mod->iMapID->Enable(TRUE);
							}
						mod->NotifyDependents(FOREVER,PART_ALL,REFMSG_CHANGE);
						mod->ip->RedrawViews(mod->ip->GetTime());
						}
					mod->SetupChannelButtons();

					break;
					}




				}
			break;

		default:
			return FALSE;
		}
	return TRUE;
	}

void UnwrapMod::SetupChannelButtons()
	{
	if (hParams && editMod==this) {		
		if (channel == 0)
			{
			iMapID->Enable(TRUE);
			iMapID->SetValue(1,TRUE);
			CheckDlgButton(hParams,IDC_MAP_CHAN1,TRUE);
			CheckDlgButton(hParams,IDC_MAP_CHAN2,FALSE);

			}
		else if (channel == 1)
			{
			CheckDlgButton(hParams,IDC_MAP_CHAN1,FALSE);
			CheckDlgButton(hParams,IDC_MAP_CHAN2,TRUE);
			iMapID->Enable(FALSE);
//			iMapID->SetValue(0,TRUE);
			}
		else
			{
			CheckDlgButton(hParams,IDC_MAP_CHAN1,TRUE);
			CheckDlgButton(hParams,IDC_MAP_CHAN2,FALSE);
			iMapID->Enable(TRUE);
			iMapID->SetValue(channel,TRUE);
			}
		}
	}


BOOL UnwrapMod::AssignController(Animatable *control,int subAnim)
	{
	return TRUE;
	}

void UnwrapMod::BeginEditParams(
		IObjParam  *ip, ULONG flags,Animatable *prev)
	{




	this->ip = ip;
	editMod  = this;
	TimeValue t = ip->GetTime();
	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_MOD_DISPLAY_ON);
	SetAFlag(A_MOD_BEING_EDITED);

	hParams  = ip->AddRollupPage( 
		hInstance, 
		MAKEINTRESOURCE(IDD_UNWRAP_PARAMS),
		UnwrapRollupWndProc,
		GetString(IDS_RB_PARAMETERS),
		(LPARAM)this);

	ip->RegisterTimeChangeCallback(this);


	}


void UnwrapMod::EndEditParams(
		IObjParam *ip,ULONG flags,Animatable *next)
	{	
	ClearAFlag(A_MOD_BEING_EDITED);

	ip->UnRegisterTimeChangeCallback(this);
	if (hParams) ip->DeleteRollupPage(hParams);
	hParams  = NULL;	
	ReleaseISpinner(iMapID); iMapID = NULL;

	TimeValue t =ip->GetTime();
	NotifyDependents(Interval(t,t), PART_ALL, REFMSG_MOD_DISPLAY_OFF);
	this->ip = NULL;

	editMod  = NULL;
	


	}



int UnwrapMod::Display(
		TimeValue t, INode* inode, ViewExp *vpt, int flags, 
		ModContext *mc) 
	{	


	return 0;	
	}


void UnwrapMod::RemoveDeadVerts(Mesh *mesh, int channel)
{
	Tab<Point3> vertList;
	Tab<int> idList;
//copy over vertlist

	int ct = mesh->getNumMapVerts(channel);
	vertList.SetCount(ct);
	Point3 *tVerts = mesh->mapVerts(channel);
	for (int i = 0; i < ct; i++)
		vertList[i] = tVerts[i];

	BitArray usedList;
	usedList.SetSize(ct);
	TVFace *tvFace = mesh->mapFaces(channel);
	if (tvFace == NULL) return;
	for (i =0; i < mesh->numFaces; i++)
		{
		for (int j = 0; j < 3; j++)
			{
			int index = tvFace[i].t[j];
			usedList.Set(index);
			}
		}
	mesh->setNumMapVerts (channel,usedList.NumberSet(),TRUE);

	int current = 0;
	tVerts = mesh->mapVerts(channel);

	for (i = 0; i < ct; i++)
		{
		if (usedList[i])
			{
			tVerts[current] = vertList[i];
//now fix up faces
			for (int j = 0; j < mesh->numFaces; j++)
				{
				for (int k = 0; k < 3; k++)
					{
					int index = tvFace[j].t[k];
					if (index == i)
						{
						tvFace[j].t[k] = current;
						}
					}

				}
			current++;
			}
		}




}


void UnwrapMod::RemoveDeadVerts(PatchMesh *mesh, int channel)
{
	Tab<PatchTVert> vertList;
	Tab<int> idList;
//copy over vertlist

	int ct = mesh->getNumMapVerts(channel);
	vertList.SetCount(ct);
	PatchTVert *tVerts = mesh->mapVerts(channel);
	for (int i = 0; i < ct; i++)
		vertList[i] = tVerts[i];

	BitArray usedList;
	usedList.SetSize(ct);
	TVPatch *tvFace = NULL;
	if (!mesh->getMapSupport(channel))
		{
		return;
		}

	tvFace = mesh->tvPatches[channel];
	if (tvFace == NULL) return;

	for (i =0; i < mesh->numPatches; i++)
		{
		int pcount = 3;
		if (mesh->patches[i].type == PATCH_QUAD) pcount = 4;

		for (int j = 0; j < pcount; j++)
			{
			int index = tvFace[i].tv[j];
			usedList.Set(index);
			}
		}
	mesh->setNumMapVerts (channel,usedList.NumberSet(),TRUE);

	int current = 0;
	tVerts = mesh->mapVerts(channel);

	for (i = 0; i < ct; i++)
		{
		if (usedList[i])
			{
			tVerts[current] = vertList[i];
//now fix up faces
			for (int j = 0; j < mesh->numPatches; j++)
				{
				int pcount = 3;
				if (mesh->patches[i].type == PATCH_QUAD) pcount = 4;

				for (int k = 0; k < pcount; k++)
					{
					int index = tvFace[j].tv[k];
					if (index == i)
						{
						tvFace[j].tv[k] = current;
						}
					}

				}
			current++;
			}
		}




}


void UnwrapMod::ModifyObject(
		TimeValue t, ModContext &mc, ObjectState *os, INode *node)
	{
//poll for material on mesh
	int CurrentChannel = 0;

	if (channel == 0)
		{
		CurrentChannel = 1;
//should be from scroller;

		}
	else if (channel == 1)
		{
		CurrentChannel = 0;
		}
	else CurrentChannel = channel;


//else copy our data into the mesh,patch or nurbs tv data
///is patch
			if (os->obj->IsSubClassOf(patchObjectClassID))
				{
// is whole mesh
				PatchObject *pobj = (PatchObject*)os->obj;
				// Apply our mapping
				PatchMesh &patch = pobj->patch;
				RemoveDeadVerts(&patch,CurrentChannel);

				}


///else convert to a mesh
			else if (os->obj->IsSubClassOf(triObjectClassID)) 
				{
// is whole mesh
				TriObject *tobj = (TriObject*)os->obj;
				// Apply our mapping
				Mesh &mesh = tobj->GetMesh();

				RemoveDeadVerts(&mesh,CurrentChannel);
					
				}

	os->obj->UpdateValidity(TEXMAP_CHAN_NUM,LocalValidity(t));	

	}

Interval UnwrapMod::LocalValidity(TimeValue t)
	{
	Interval iv = FOREVER;
	return iv;
	}

RefTargetHandle UnwrapMod::GetReference(int i)
	{
		return NULL;
	}

void UnwrapMod::SetReference(int i, RefTargetHandle rtarg)
	{
	}

Animatable* UnwrapMod::SubAnim(int i)
	{
	return NULL;
	}

TSTR UnwrapMod::SubAnimName(int i)
	{
	TSTR buf;
//	buf.printf(_T("Point %d"),i+1);
	buf.printf(_T(" "));
	return buf;
	}


RefTargetHandle UnwrapMod::Clone(RemapDir& remap)
	{
	UnwrapMod *mod = new UnwrapMod;
	BaseClone(this, mod, remap);

	return mod;
	}

#define NAMEDSEL_STRING_CHUNK	0x2809
#define NAMEDSEL_ID_CHUNK		0x2810


RefResult UnwrapMod::NotifyRefChanged(
		Interval changeInt, 
		RefTargetHandle hTarget, 
		PartID& partID, 
		RefMessage message)
	{
	switch (message) {
		case REFMSG_CHANGE:
			if (editMod==this ) {
				}
			break;

		}
	return REF_SUCCEED;
	}

#define CHANNEL_CHUNK	0x0260

IOResult UnwrapMod::Save(ISave *isave)
	{
	ULONG nb;
	Modifier::Save(isave);


	isave->BeginChunk(CHANNEL_CHUNK);
	isave->Write(&channel, sizeof(channel), &nb);
	isave->EndChunk();

		
	return IO_OK;
	}


IOResult UnwrapMod::Load(ILoad *iload)
	{

	IOResult res;
	ULONG nb;
	Modifier::Load(iload);
//check for backwards compatibility

	while (IO_OK==(res=iload->OpenChunk())) {
		switch(iload->CurChunkID())  {
			case CHANNEL_CHUNK:
				iload->Read(&channel, sizeof(channel), &nb);
				break;			



			}
		iload->CloseChunk();
		if (res!=IO_OK) 
			return res;
		}


	return IO_OK;
	}

