/**********************************************************************
 *<
	FILE: asciiout.cpp

	DESCRIPTION:  A utility that outputs an object in ASCII form

	CREATED BY: Rolf Berteig

	HISTORY: created December 26 1995

 *>	Copyright (c) 1994, All Rights Reserved.
 **********************************************************************/
#include "util.h"
#include "utilapi.h"
#include "bmmlib.h"

#define ASCII_OUT_CLASS_ID		0x4c2b5a6c


BOOL HitChild(INode *node,INode *n)
{
	for (int i =0; i < node->NumberOfChildren(); i++)
		{
		 INode *childNode = node->GetChildNode(i);
		 if (childNode==n) return TRUE;
		 if (HitChild(childNode,n)) return TRUE;
		}
	return FALSE;

}


BOOL ValidateNode(INode *n)
{
//get root node
	
	INode *baseNode = GetCOREInterface()->GetRootNode();
	for (int i =0; i < baseNode->NumberOfChildren(); i++)
		{
		 INode *childNode = baseNode->GetChildNode(i);
		 if (childNode==n) return TRUE;
		 if (HitChild(childNode,n)) return TRUE;
		}
	return FALSE;
//loop through all children looking for match
}


class EdgeList
	{
	public:
		BOOL visible;
		int b;
		Tab<int> connectedFaces;
	};

class EdgeClass
	{
	public:
		Tab<EdgeList*> edges;
		void Free()
			{
			for (int i =0; i < edges.Count(); i++)
				{
				EdgeList *ePtr = edges[i];
				ePtr->connectedFaces.ZeroCount();
				delete ePtr;
				edges[i] = NULL;
				}
			edges.Resize(0);
			};
	};

class UVEdgeClass
	{
public:
	void AddEdge(int a, int b, int faceID, BOOL visible);
	void BuildEdgeList(Mesh *msh, int channel);

	void FreeEdgeList();
	~UVEdgeClass()
		{
		FreeEdgeList();
		}

	Tab<EdgeClass*> e;
	};


void UVEdgeClass::FreeEdgeList()
	{
	for (int i = 0; i < e.Count(); i++)
		{
		EdgeClass *ePtr = e[i];
		ePtr->Free();
		delete ePtr;
		}
	e.Resize(0);
	}

void UVEdgeClass::AddEdge(int a, int b, int faceID, BOOL vis)
	{
	if (e[a] == NULL)
		{
		e[a] = new EdgeClass;
		e[a]->edges.SetCount(1);
		e[a]->edges[0] = new EdgeList;
		e[a]->edges[0]->visible = vis;
		e[a]->edges[0]->b = b;
		e[a]->edges[0]->connectedFaces.Append(1,&faceID);

		}
	else
		{
		EdgeClass *edgePtr = e[a];
		BOOL found = FALSE;
		for (int i =0; i < edgePtr->edges.Count(); i++)
			{
			if (b == edgePtr->edges[i]->b)
				{
				found = TRUE;
				BOOL hitFace = FALSE;
				for (int j=0; j < edgePtr->edges[i]->connectedFaces.Count();j++)
					{
					if (edgePtr->edges[i]->connectedFaces[j] == faceID)
						{
						hitFace = TRUE;
						j = edgePtr->edges[i]->connectedFaces.Count();
						}
					}
				if (!hitFace)
					{
					if ((!edgePtr->edges[i]->visible) && (vis))
						edgePtr->edges[i]->visible = vis;

					edgePtr->edges[i]->connectedFaces.Append(1,&faceID);
					}
				i = edgePtr->edges.Count();
				}
			}
		if (!found)
			{
			EdgeList *el = new EdgeList;
			el-> b = b;
			el->visible = vis;

			el->connectedFaces.Append(1,&faceID);

			edgePtr->edges.Append(1,&el);
			}
		}
	}

void UVEdgeClass::BuildEdgeList(Mesh *msh, int channel)
	{
	if (!msh->mapSupport(channel)) return;
//get number texture vertices
	int numberTextureVerts =0;
	numberTextureVerts = msh->getNumMapVerts(channel);
//allocate that many edges
	e.SetCount(numberTextureVerts);
	for (int i =0; i < numberTextureVerts; i++)
		e[i] = NULL;
//get texture face pointer
	int faceCount;
	TVFace *tvFaces=NULL;
	faceCount = msh->numFaces;
	tvFaces = msh->mapFaces(channel);
	Face *faceList =  msh->faces;

	if (tvFaces)
		{
		for (i =0; i < faceCount; i++)
			{
			int a,b;
			for (int j =0; j < 3; j++)
				{
				a = tvFaces->t[j];
				if (j==2)
				b = tvFaces->t[0];
				else b = tvFaces->t[j+1];
				if (a!=b)
					{
					if (a>b)
						{
						int temp;
						temp = a;
						a = b;
						b = temp;
						}
					BOOL vis;
					if (j==0)
						vis = faceList->flags & EDGE_A;
					else if (j==1)
						vis = faceList->flags & EDGE_B;
					else 
						vis = faceList->flags & EDGE_C;

					AddEdge(a,b,i,vis);
					
					}
				}
			
			tvFaces++;
			faceList++;
			}
		}

	}

class AsciiOut : public UtilityObj {
	public:
		BOOL displayOpenEdges;
		int channel;
		ISpinnerControl *Channelspin;

		UVEdgeClass uvEdges;
		
		IUtil *iu;
		Interface *ip;
		HWND hPanel;
		ICustButton *iPick;
		ISpinnerControl *Widthspin;
		ISpinnerControl *Heightspin;
		ISpinnerControl *MatIDspin;

		IColorSwatch *backGroundColor;
		IColorSwatch *lineColor;
		IColorSwatch *tickColor;
		IColorSwatch *openColor;

		Color bColor, lColor, tColor, oColor;
		int mapWidth,mapHeight, matID, mapChannel;
		BOOL useMatID, drawAllEdges,markOpenEdges;


		BitmapInfo bi;

		AsciiOut();
		~AsciiOut()
			{
			map->DeleteThis();
			};
		void BeginEditParams(Interface *ip,IUtil *iu);
		void EndEditParams(Interface *ip,IUtil *iu);
		void DeleteThis() {}

		void Init(HWND hWnd);
		void Destroy(HWND hWnd);

		INode *objectNode;
		Bitmap *map;

		void UpdateEdges();

		void SetNode(INode *node);
		void SaveBitmap();
		void UpdateBitmap();

		void RebuildMap();


		void BXPLine(long x1,long y1,long x2,long y2,
				WORD r, WORD g, WORD b,
				Bitmap *map,
				BOOL wrap);
	};

static AsciiOut theAsciiOut;

class AsciiOutClassDesc:public ClassDesc {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading = FALSE) {return &theAsciiOut;}
	const TCHAR *	ClassName() {return GetString(IDS_RB_ASCIIOBJECTOUT);}
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID		ClassID() {return Class_ID(ASCII_OUT_CLASS_ID,0);}
	const TCHAR* 	Category() {return _T("");}
	};

static AsciiOutClassDesc asciiOutDesc;
ClassDesc* GetAsciiOutDesc() {return &asciiOutDesc;}

class AsciiOutPickNodeCallback : public PickNodeCallback {
	public:		
		BOOL Filter(INode *node);
	};

BOOL AsciiOutPickNodeCallback::Filter(INode *node)
	{
	ObjectState os = node->EvalWorldState(theAsciiOut.ip->GetTime());
	if (os.obj->SuperClassID()==GEOMOBJECT_CLASS_ID &&
		os.obj->IsRenderable()) return TRUE;
	else return FALSE;
	}

static AsciiOutPickNodeCallback thePickFilt;

class AsciiOutPickModeCallback : public PickModeCallback {
	public:		
		BOOL HitTest(IObjParam *ip,HWND hWnd,ViewExp *vpt,IPoint2 m,int flags);
		BOOL Pick(IObjParam *ip,ViewExp *vpt);
		
		void EnterMode(IObjParam *ip) {theAsciiOut.iPick->SetCheck(TRUE);}
		void ExitMode(IObjParam *ip) {theAsciiOut.iPick->SetCheck(FALSE);}

		PickNodeCallback *GetFilter() {return &thePickFilt;}
		BOOL RightClick(IObjParam *ip,ViewExp *vpt) {return TRUE;}

		HWND h;
	};

static AsciiOutPickModeCallback thePickMode;

BOOL AsciiOutPickModeCallback::HitTest(
		IObjParam *ip,HWND hWnd,ViewExp *vpt,IPoint2 m,int flags)
	{
	return ip->PickNode(hWnd,m,&thePickFilt)?TRUE:FALSE;
	}

BOOL AsciiOutPickModeCallback::Pick(IObjParam *ip,ViewExp *vpt)
	{
	INode *node = vpt->GetClosestHit();
	if (node) 
		{
		theAsciiOut.SetNode(node);
		return TRUE;
		}
	else
		{
		return FALSE;
		}			
	}


static BOOL CALLBACK AsciiOutDlgProc(
		HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
	switch (msg) {
		case WM_INITDIALOG:
			theAsciiOut.Init(hWnd);			
			break;
		
		case WM_DESTROY:
			theAsciiOut.Destroy(hWnd);
			break;

		case CC_COLOR_CHANGE:
			switch( LOWORD(wParam) ) 
				{
				case IDC_COLOR_SWATCH_BACKGROUND:
				case IDC_COLOR_SWATCH_LINE:
				case IDC_COLOR_SWATCH_TICK:
				case IDC_COLOR_SWATCH_EDGE:
					theAsciiOut.UpdateBitmap();
					break;
				
				}

			break;
		case WM_CUSTEDIT_ENTER :
			switch( LOWORD(wParam) ) 
				{
				case IDC_WIDTH_EDIT:
				case IDC_HEIGHT_EDIT:
					{
					theAsciiOut.RebuildMap();
					break;
					}
				case IDC_MATID_EDIT:
					theAsciiOut.UpdateBitmap();
					break;
				case IDC_MAP_CHAN:
					{
					theAsciiOut.UpdateEdges();
					theAsciiOut.UpdateBitmap();
					break;
					}

				
				}
			break;

		case CC_SPINNER_BUTTONUP:
			switch( LOWORD(wParam) ) 
				{
				case IDC_MAP_CHAN_SPIN:
					{
					theAsciiOut.UpdateEdges();
					theAsciiOut.UpdateBitmap();
					break;
					}
				case IDC_WIDTH_SPIN:
				case IDC_HEIGHT_SPIN:
					{
					theAsciiOut.RebuildMap();
					break;
					}
				case IDC_MATID_SPIN:
					theAsciiOut.UpdateBitmap();
					break;
				}
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
/*				case IDOK:
					theAsciiOut.iu->CloseUtility();
					break;				
*/		
				case IDC_MATID_CHECK:
				case IDC_ALLEDGES_CHECK:
				case IDC_OPENDGES_CHECK:
					
					theAsciiOut.UpdateBitmap();
					break;
				case IDC_ASCIIOUT_SAVE:
					theAsciiOut.SaveBitmap(); 
					break;

				case IDC_ASCIIOUT_PICK:
					theAsciiOut.ip->SetPickMode(&thePickMode); 
					break;
				case IDC_HELPBUTTON:
					ShellExecute(GetCOREInterface()->GetMAXHWnd(), "open", "iexplore.exe", "www.max3dstuff.com/max4/unwrapUtil/help.html", NULL, SW_SHOWNORMAL);
					break;
				}
			break;

		default:
			return FALSE;
		}
	return TRUE; 
	}

AsciiOut::AsciiOut()
	{
	iu = NULL;
	ip = NULL;	
	hPanel = NULL;	
	iPick = NULL;
	Widthspin = NULL;
	Heightspin = NULL;
	MatIDspin = NULL;
	Channelspin = NULL;

	backGroundColor = NULL;
	lineColor = NULL;
	tickColor = NULL;
	openColor = NULL;
	
	objectNode = NULL;
	map = NULL;

	bColor = Color(1.0f,1.0f,1.0f);
	lColor = Color(0.0f,0.0f,0.0f);
	tColor = Color(1.0f,0.0f,0.0f);
	oColor = Color(0.0f,1.0f,0.0f);
	mapWidth = 640;
	mapHeight = 480;
	matID = 1;
	mapChannel = 1;
	useMatID = FALSE;
	drawAllEdges = FALSE;
	markOpenEdges = TRUE;

	}

void AsciiOut::BeginEditParams(Interface *ip,IUtil *iu) 
	{
	this->iu = iu;
	this->ip = ip;
	hPanel = ip->AddRollupPage(
		hInstance,
		MAKEINTRESOURCE(IDD_ASCIIOUT_PANEL),
		AsciiOutDlgProc,
		GetString(IDS_RB_ASCIIOBJECTOUT),
		0);
	}
	
void AsciiOut::EndEditParams(Interface *ip,IUtil *iu) 
	{
	ip->ClearPickMode();
	this->iu = NULL;
	this->ip = NULL;
	ip->DeleteRollupPage(hPanel);
	hPanel = NULL;
	}

void AsciiOut::Init(HWND hWnd)
	{
	iPick = GetICustButton(GetDlgItem(hWnd,IDC_ASCIIOUT_PICK));
	iPick->SetType(CBT_CHECK);
	iPick->SetHighlightColor(GREEN_WASH);
	Widthspin = SetupIntSpinner(hWnd,IDC_WIDTH_SPIN,IDC_WIDTH_EDIT,0,99999999,640);
	Heightspin = SetupIntSpinner(hWnd,IDC_HEIGHT_SPIN,IDC_HEIGHT_EDIT,0,99999999,480);
	MatIDspin = SetupIntSpinner(hWnd,IDC_MATID_SPIN,IDC_MATID_EDIT,0,10000,0);

	Channelspin = SetupIntSpinner(hWnd,IDC_MAP_CHAN_SPIN,IDC_MAP_CHAN,0,99,1);

	backGroundColor = GetIColorSwatch(GetDlgItem(hWnd,IDC_COLOR_SWATCH_BACKGROUND), RGB(255,255,255), _T("Background Color"));
	lineColor = GetIColorSwatch(GetDlgItem(hWnd,IDC_COLOR_SWATCH_LINE), RGB(0,0,0), _T("Line Color"));
	tickColor = GetIColorSwatch(GetDlgItem(hWnd,IDC_COLOR_SWATCH_TICK), RGB(128,0,0), _T("Tick Color"));
	openColor = GetIColorSwatch(GetDlgItem(hWnd,IDC_COLOR_SWATCH_EDGE), RGB(0,200,0), _T("Open Edge Color"));


	backGroundColor->SetColor(bColor);
	lineColor->SetColor(lColor);
	tickColor->SetColor(tColor);
	openColor->SetColor(oColor);
	

	Widthspin->SetValue(mapWidth,FALSE);
	Heightspin->SetValue(mapHeight,FALSE);
	MatIDspin->SetValue(matID,FALSE);
	Channelspin->SetValue(mapChannel,FALSE);
	

	if (useMatID) CheckDlgButton(hPanel,IDC_MATID_CHECK,BST_CHECKED);
	else CheckDlgButton(hPanel,IDC_MATID_CHECK,BST_UNCHECKED);

	if (drawAllEdges) CheckDlgButton(hPanel,IDC_ALLEDGES_CHECK,BST_CHECKED);
	else CheckDlgButton(hPanel,IDC_ALLEDGES_CHECK,BST_UNCHECKED);

	if (markOpenEdges) CheckDlgButton(hPanel,IDC_OPENDGES_CHECK,BST_CHECKED);
	else CheckDlgButton(hPanel,IDC_OPENDGES_CHECK,BST_UNCHECKED);
	


	if (!ValidateNode(objectNode))
		objectNode = NULL;

//validate node
	if (objectNode)
		iPick->SetText(objectNode->GetName());
	CheckRadioButton( hPanel,IDC_MAP_TEXMAP,IDC_MAP_VERTCOL,IDC_MAP_TEXMAP);
 

	}




void AsciiOut::Destroy(HWND hWnd)
	{

	bColor = backGroundColor->GetColor();
	lColor = lineColor->GetColor();
	tColor = tickColor->GetColor();
	oColor = openColor->GetColor();
	

	mapWidth = Widthspin->GetIVal();
	mapHeight = Heightspin->GetIVal();
	matID = MatIDspin->GetIVal();
	mapChannel = Channelspin->GetIVal();
	


	useMatID= IsDlgButtonChecked(hPanel,IDC_MATID_CHECK);
	drawAllEdges= IsDlgButtonChecked(hPanel,IDC_ALLEDGES_CHECK);
	markOpenEdges= IsDlgButtonChecked(hPanel,IDC_OPENDGES_CHECK);


	ReleaseISpinner(Widthspin);
	ReleaseISpinner(Heightspin);
	ReleaseISpinner(MatIDspin);
	ReleaseISpinner(Channelspin);

	ReleaseICustButton(iPick);
	ReleaseIColorSwatch(backGroundColor);
	ReleaseIColorSwatch(lineColor);
	ReleaseIColorSwatch(tickColor);
	ReleaseIColorSwatch(openColor);
	iPick = NULL;
	}

class NullView: public View {
	public:
		Point2 ViewToScreen(Point3 p) { return Point2(p.x,p.y); }
		NullView() { worldToView.IdentityMatrix(); screenW=640.0f; screenH = 480.0f; }
	};


void AsciiOut::RebuildMap()
	{
	if (!ValidateNode(objectNode))
		objectNode = NULL;

	if (objectNode)
		{
		int w,h;
		w = Widthspin->GetIVal();
		h = Heightspin->GetIVal();
		if ((w != bi.Width()) || (h!=bi.Height()))
			{
			bi.SetWidth(Widthspin->GetIVal());
			bi.SetHeight(Heightspin->GetIVal());
			map->UnDisplay();
			map->DeleteThis();
			map = NULL;
			UpdateBitmap();
			if (map) map->Display();
			}
		}

	}

void AsciiOut::UpdateEdges()
	{
	if (!ValidateNode(objectNode))
		objectNode = NULL;

	if (objectNode)
		{
		ObjectState os = objectNode->EvalWorldState(theAsciiOut.ip->GetTime());
		assert(os.obj->SuperClassID()==GEOMOBJECT_CLASS_ID);
		BOOL needDel;
		NullView nullView;
		Mesh *mesh = ((GeomObject*)os.obj)->GetRenderMesh(ip->GetTime(),objectNode,nullView,needDel);
		if (!mesh) return;
	
		channel = Channelspin->GetIVal();

		uvEdges.BuildEdgeList(mesh, channel);

		if (needDel) delete mesh;
		}
	}

void AsciiOut::SetNode(INode *node)
	{
	objectNode = node;
	bi.SetWidth(Widthspin->GetIVal());
	bi.SetHeight(Heightspin->GetIVal());
	bi.SetType(BMM_TRUE_64);
	iPick->SetText(node->GetName());

	UpdateEdges();

	UpdateBitmap();

	if (map) map->Display();
	}

void AsciiOut::SaveBitmap()
	{
	UpdateBitmap();
	BOOL iret = TheManager->SelectFileOutput(&bi ,hPanel ,"Select File");
	if (iret)
		{
		map->OpenOutput(&bi);
		map->Write(&bi);
		map->Close(&bi);
		}

	}

void AsciiOut::UpdateBitmap()
	{
//get object	
	if (map == NULL)
		map = TheManager->Create(&bi);
	INode *node=NULL;

	channel = Channelspin->GetIVal();

	if (!ValidateNode(objectNode))
		objectNode = NULL;

	if (objectNode == NULL) return;
	else node = objectNode;
	BMM_Color_64 bit;
	Point3 VertA,VertB,VertC;
	int MatID1,MatID2;

	bit.r = 0;
	bit.g = 0;
	bit.b = 0;
	bit.a = 0xFFFF;

	COLORREF color = backGroundColor->GetColor();
	int r = (int) GetRValue(color)*512;
	int g = (int) GetGValue(color)*512;
	int b = (int) GetBValue(color)*512;


	map->Fill(r,g,b,0);


	color = lineColor->GetColor();
	int lr = (int) GetRValue(color)*512;
	int lg = (int) GetGValue(color)*512;
	int lb = (int) GetBValue(color)*512;


	color = tickColor->GetColor();
	int tr = (int) GetRValue(color)*512;
	int tg = (int) GetGValue(color)*512;
	int tb = (int) GetBValue(color)*512;

	color = openColor->GetColor();
	int or = (int) GetRValue(color)*512;
	int og = (int) GetGValue(color)*512;
	int ob = (int) GetBValue(color)*512;


	ObjectState os = node->EvalWorldState(theAsciiOut.ip->GetTime());
	assert(os.obj->SuperClassID()==GEOMOBJECT_CLASS_ID);
	BOOL needDel;
	NullView nullView;
	Mesh *mesh = ((GeomObject*)os.obj)->GetRenderMesh(ip->GetTime(),node,nullView,needDel);
	if (!mesh) return;
	if (!mesh->mapSupport(channel)) return;

	Matrix3 tm = node->GetObjTMAfterWSM(theAsciiOut.ip->GetTime());

	BitArray sel = mesh->VertSel();
	Face *FaceList =  mesh->faces;
	TVFace	*TVFaceList = mesh->mapFaces(channel);

//draw lines
	UVVert *tverts = mesh->mapVerts(channel);
	MatID1 = MatIDspin->GetIVal();
	BOOL useMatIDs = IsDlgButtonChecked(hPanel,IDC_MATID_CHECK);
	for (int i=0; i< uvEdges.e.Count(); i++) 
		{
		int a,b;
		a = i;
		if (uvEdges.e[i])
			{
			for (int j = 0; j < uvEdges.e[i]->edges.Count(); j++)
				{
				BOOL draw = FALSE;
				if (useMatIDs)
					{
					for (int k = 0; k < uvEdges.e[i]->edges[j]->connectedFaces.Count(); k++)
						{
						 
						MatID2 = FaceList[uvEdges.e[i]->edges[j]->connectedFaces[k]].getMatID()+1;;
						if (MatID2 == MatID1)
							{
							draw = TRUE;
							k = uvEdges.e[i]->edges[j]->connectedFaces.Count();
							}
						}
					}
				else draw = TRUE;
				 
				if (( (uvEdges.e[i]->edges[j]->visible) || (IsDlgButtonChecked(hPanel,IDC_ALLEDGES_CHECK)) ) && (draw))
					{
					b = uvEdges.e[i]->edges[j]->b;
					VertA = tverts[a];
					VertB = tverts[b];
					if ( (!IsDlgButtonChecked(hPanel,IDC_OPENDGES_CHECK)) ||
					   (uvEdges.e[i]->edges[j]->connectedFaces.Count() > 1) )
						BXPLine((long) (map->Width()*VertA.x),map->Height()-1-(long) ((map->Height()-1)*VertA.y),
								(long) (map->Width()*VertB.x),map->Height()-1-(long) ((map->Height()-1)*VertB.y),
							   lr, lg, lb,
							map,TRUE);
					else
						BXPLine((long) (map->Width()*VertA.x),map->Height()-1-(long) ((map->Height()-1)*VertA.y),
								(long) (map->Width()*VertB.x),map->Height()-1-(long) ((map->Height()-1)*VertB.y),
							   or, og, ob,
							map,TRUE);
					}

				}
			}
		}

//put in ticks

	for (i=0; i<mesh->getNumFaces(); i++) 
		{
		 if  (TVFaceList)   
			  
			 {
//get tvverst
			 MatID2 = FaceList->getMatID()+1;
			 if ( (!useMatIDs) ||
				  (MatID1 == MatID2)    )
			 {				 
			 VertA = (Point3) tverts[TVFaceList->t[0]];
			 VertB = (Point3) tverts[TVFaceList->t[1]];
			 VertC = (Point3) tverts[TVFaceList->t[2]];

/*			 map->PutPixels((int)(map->Width()*VertA.x),map->Height()-1-(int)((map->Height()-1)*VertA.y),1,&bit);
			 map->PutPixels((int)(map->Width()*VertB.x),map->Height()-1-(int)((map->Height()-1)*VertB.y),1,&bit);
			 map->PutPixels((int)(map->Width()*VertC.x),map->Height()-1-(int)((map->Height()-1)*VertC.y),1,&bit);

//Draw Lines from 0A to 1B
			 if ( (FaceList->flags & EDGE_A) || (IsDlgButtonChecked(hPanel,IDC_ALLEDGES_CHECK)) )
				{
				BXPLine((long) (map->Width()*VertA.x),map->Height()-1-(long) ((map->Height()-1)*VertA.y),
						(long) (map->Width()*VertB.x),map->Height()-1-(long) ((map->Height()-1)*VertB.y),
					   lr, lg, lb,
					   map,TRUE);

				}
//Draw Lines from 1B to 2C
			 if ( (FaceList->flags & EDGE_B) || (IsDlgButtonChecked(hPanel,IDC_ALLEDGES_CHECK)) )
				{
				BXPLine((long) (map->Width()*VertB.x),map->Height()-1-(long) ((map->Height()-1)*VertB.y),
						(long) (map->Width()*VertC.x),map->Height()-1-(long) ((map->Height()-1)*VertC.y),
					   lr, lg, lb,
					   map,TRUE);

				}
//Draw Lines from 1A to 2C
			 if ( (FaceList->flags & EDGE_C) || (IsDlgButtonChecked(hPanel,IDC_ALLEDGES_CHECK)) )
				{
				BXPLine((long) (map->Width()*VertA.x),map->Height()-1-(long) ((map->Height()-1)*VertA.y),
						(long) (map->Width()*VertC.x),map->Height()-1-(long) ((map->Height()-1)*VertC.y),
					   lr, lg, lb,
					   map,TRUE);

				}
*/

			 
			 
			 if (sel[FaceList->v[0]])
				{
//draw red tick

				BXPLine((long) (map->Width()*VertA.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertA.y)-4,
						(long) (map->Width()*VertA.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertA.y)+4,
					   tr, tg, tb,
					   map,FALSE);
				BXPLine((long) (map->Width()*VertA.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertA.y)-4,
						(long) (map->Width()*VertA.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertA.y)+4,
					   tr, tg, tb,
					   map,FALSE);

			 }
			  if (sel[FaceList->v[1]])
				{
//draw red tick
				BXPLine((long) (map->Width()*VertB.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertB.y)-4,
						(long) (map->Width()*VertB.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertB.y)+4,
					   tr, tg, tb,
					   map,FALSE);
				BXPLine((long) (map->Width()*VertB.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertB.y)-4,
						(long) (map->Width()*VertB.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertB.y)+4,
					   tr, tg, tb,
					   map,FALSE);
				}

			if (sel[FaceList->v[2]])
				{
//draw red tick
				BXPLine((long) (map->Width()*VertC.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertC.y)-4,
						(long) (map->Width()*VertC.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertC.y)+4,
					   tr, tg, tb,
					   map,FALSE);
				BXPLine((long) (map->Width()*VertC.x)+4,map->Height()-1-(long) ((map->Height()-1)*VertC.y)-4,
						(long) (map->Width()*VertC.x)-4,map->Height()-1-(long) ((map->Height()-1)*VertC.y)+4,
					   tr, tg, tb,
					   map,FALSE);
				}

			}

		 }
		 FaceList++;
		 TVFaceList++;

		}

	if (needDel) delete mesh;
	map->RefreshWindow();
	}

void AsciiOut::BXPLine(long x1,long y1,long x2,long y2,
					   WORD r, WORD g, WORD b,
					   Bitmap *map, BOOL wrap)



{
  long i,px,py,x,y;
  long dx,dy,dxabs,dyabs,sdx,sdy;
  long count;

  BMM_Color_64 bit;

  bit.r = r;
  bit.g = g;
  bit.b = b;
  bit.a = 0xFFFF;

/*
  if (x1<0) x1= 0;
  if (x2<0) x2= 0;
  if (y1<0) y1= 0;
  if (y2<0) y2= 0;

  if (x1>=map->GetWidth()) x1= map->GetWidth()-1;
  if (x2>=map->GetWidth()) x2= map->GetWidth()-1;
  if (y1>=h) y1= h-1;
  if (y2>=h) y2= h-1;
 */

 dx = x2-x1;
 dy = y2-y1;

 if (dx >0)
	 sdx = 1;
	else
	 sdx = -1;

 if (dy >0)
	 sdy = 1;
	else
	 sdy = -1;


 dxabs = abs(dx);
 dyabs = abs(dy);

 x=0;
 y=0;
 px=x1;
 py=y1;

 count = 0;

 if (dxabs >= dyabs)
	 for (i=0; i<=dxabs; i++)
		{
		 y +=dyabs;
		 if (y>=dxabs)
			{
			 y-=dxabs;
			 py+=sdy;
			}
		if (wrap)
			{
			 if (px>=map->Width())
				{
				px = 0;
				}
			 if (px<0)
				{
				px = map->Width()-1;
				}
			 if (py>=map->Height())
				{
				py = 0;
				}
			 if (py<0)
				{
				px = map->Height()-1;
				}
			map->PutPixels(px,py,1,&bit);
			}
			else
			{
			 if ( (px>=0) && (px<map->Width()) &&
				  (py>=0) && (py<map->Height())    )
				{
				map->PutPixels(px,py,1,&bit);
				}

			}
		 px+=sdx;
		 }


		 else

	 for (i=0; i<=dyabs; i++)
		{
		 x+=dxabs;
		 if (x>=dyabs)
			{
			 x-=dyabs;
			 px+=sdx;
			}
		if (wrap)
			{
			 if (px>=map->Width())
				{
				px = 0;
				}
			 if (px<0)
				{
				px = map->Width()-1;
				}
			 if (py>=map->Height())
				{
				py = 0;
				}
			 if (py<0)
				{
				px = map->Height()-1;
				}
			map->PutPixels(px,py,1,&bit);
			}
			else
			{
			 if ( (px>=0) && (px<map->Width()) &&
				  (py>=0) && (py<map->Height())    )
				{
				map->PutPixels(px,py,1,&bit);
				}

			}

		 map->PutPixels(px,py,1,&bit);
		 py+=sdy;
		}
(count)--;
}
