//-----------------------------------------------------------------------------
// -------------------
// File	....:	Glow.cpp
// -------------------
// Author...:	Gus J	Grubba
// Date	....:	September 1995
// Descr....:	Glow Image Filter
//
// History	.:	Feb, 17 1996 -	Started
//				
//-----------------------------------------------------------------------------
		
//--	Include files

#include <Max.h>
#include <bmmlib.h>
#include <fltlib.h>
#include "Glow.h"
#include "resource.h"

//--	Globals ------------------------------------------------------------------

HINSTANCE hInst = NULL;

static ISpinnerControl	*mtlspin = NULL;
static ISpinnerControl	*nodspin = NULL;
static ISpinnerControl	*closespin = NULL;
static ISpinnerControl	*farspin = NULL;

float StartDist= 0.0f,RangeDist = 0.0f,EndDist = 0.0f;

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//--	DLL Declaration

BOOL WINAPI DllMain(HINSTANCE hDLLInst, DWORD fdwReason, LPVOID lpvReserved)	{
	switch (fdwReason) {
		 case	DLL_PROCESS_ATTACH:
				if (hInst)
					return(FALSE);
				hInst = hDLLInst;
				break;
		 case	DLL_PROCESS_DETACH:
				hInst =	NULL;
				break;
		 case	DLL_THREAD_ATTACH:
				break;
		 case	DLL_THREAD_DETACH:
				break;
	}
	return TRUE;
}

TCHAR *GetString(int id)
	{
	static TCHAR buf[256];

	if (hInst)
		return LoadString(hInst, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
	}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Glow	Class	Description

class GLOWClassDesc:public ClassDesc {
	
	public:

		int				IsPublic ( )					{ return	1; }
		void			*Create (BOOL loading=FALSE)	{ return	new ImageFilter_Glow; }
		const	TCHAR	*ClassName ( )					{ return	GetString(IDS_DB_GLOW);	}
		SClass_ID		SuperClassID ( )				{ return	FLT_CLASS_ID; }
		Class_ID		ClassID	( )						{ return	Class_ID(0x3fd469a4, 0x70b2507e); }
		const	TCHAR	*Category ( )					{ return	GetString(IDS_DB_IMAGE_FILTER); }

};

static GLOWClassDesc GLOWDesc;

//-----------------------------------------------------------------------------
// Interface

DLLEXPORT const TCHAR * LibDescription (	) { 
 	return GetString(IDS_DB_GLOW_FILTER); 
}

DLLEXPORT int	LibNumberClasses ( ) { 
	return 1; 
}

DLLEXPORT ClassDesc	*LibClassDesc(int	i) {
	switch(i) {
		case 0:		return &GLOWDesc;	break;
		default:	return 0;			break;
	}
}

DLLEXPORT ULONG LibVersion (	)	{ 
	return (VERSION_3DSMAX);	
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::ImageFilter_Glow()
//

ImageFilter_Glow::ImageFilter_Glow() {
	data.version = GLOWVERSION;
	data.type = IDC_ALL_BUTT;
	data.mtl  = 0;
	data.node = 0;
	data.userange = 0;
	data.effect = IDC_EFFECT1;
	data.close = 0.0f;
	data.fard = -99999.0f;

}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::HandleInputs()
//

void ImageFilter_Glow::HandleInputs( HWND hWnd ) {
	HWND hDlg;

	BOOL flag = IsDlgButtonChecked(hWnd,IDC_MTLID_BUTT);
	BOOL flag1 = IsDlgButtonChecked(hWnd,IDC_NODEID_BUTT);
	BOOL flag2 = IsDlgButtonChecked(hWnd,IDC_ALL_BUTT);


	if (flag)
		{
		hDlg = GetDlgItem(hWnd,IDC_MTLID_EDIT);
		EnableWindow(hDlg,TRUE);
		hDlg = GetDlgItem(hWnd,IDC_MTLID_SPIN);
		EnableWindow(hDlg,TRUE);


		hDlg = GetDlgItem(hWnd,IDC_NODEID_EDIT);
		EnableWindow(hDlg,FALSE);
		hDlg = GetDlgItem(hWnd,IDC_NODEID_SPIN);
		EnableWindow(hDlg,FALSE);
		}
	else if (flag1)
		{
		hDlg = GetDlgItem(hWnd,IDC_MTLID_EDIT);
		EnableWindow(hDlg,FALSE);
		hDlg = GetDlgItem(hWnd,IDC_MTLID_SPIN);
		EnableWindow(hDlg,FALSE);


		hDlg = GetDlgItem(hWnd,IDC_NODEID_EDIT);
		EnableWindow(hDlg,TRUE);
		hDlg = GetDlgItem(hWnd,IDC_NODEID_SPIN);
		EnableWindow(hDlg,TRUE);
		}
	else
		{
		hDlg = GetDlgItem(hWnd,IDC_MTLID_EDIT);
		EnableWindow(hDlg,FALSE);
		hDlg = GetDlgItem(hWnd,IDC_MTLID_SPIN);
		EnableWindow(hDlg,FALSE);


		hDlg = GetDlgItem(hWnd,IDC_NODEID_EDIT);
		EnableWindow(hDlg,FALSE);
		hDlg = GetDlgItem(hWnd,IDC_NODEID_SPIN);
		EnableWindow(hDlg,FALSE);
		}



	

}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::Control()
//

BOOL ImageFilter_Glow::Control(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)	{

	switch (message) {

		case WM_INITDIALOG:
			CenterWindow(hWnd,GetParent(hWnd));
			SetCursor(LoadCursor(NULL,IDC_ARROW));

			CheckRadioButton(
				hWnd,
				IDC_MTLID_BUTT,
				IDC_ALL_BUTT,
				data.type
			);

			
			CheckRadioButton(
				hWnd,
				IDC_EFFECT1,
				IDC_EFFECT6,
				data.effect
			);


			CheckDlgButton(hWnd,IDC_USERANGE_CHECK,data.userange);
							

			mtlspin	= GetISpinner(GetDlgItem(hWnd, IDC_MTLID_SPIN));
			mtlspin->LinkToEdit( GetDlgItem(hWnd,IDC_MTLID_EDIT), EDITTYPE_INT );
			mtlspin->SetLimits(	1,8, FALSE );
			mtlspin->SetValue(data.mtl,FALSE);

			nodspin	= GetISpinner(GetDlgItem(hWnd, IDC_NODEID_SPIN));
			nodspin->LinkToEdit( GetDlgItem(hWnd,IDC_NODEID_EDIT), EDITTYPE_INT );
			nodspin->SetLimits(	1,65535, FALSE );
			nodspin->SetValue(data.node,FALSE);

			closespin	= GetISpinner(GetDlgItem(hWnd, IDC_CLOSE_SPIN));
			closespin->LinkToEdit( GetDlgItem(hWnd,IDC_CLOSE_EDIT), EDITTYPE_FLOAT );
			closespin->SetLimits(-999999.0f, 0.0f, FALSE );
			closespin->SetValue(data.close,FALSE);
			
			farspin	= GetISpinner(GetDlgItem(hWnd, IDC_FAR_SPIN));
			farspin->LinkToEdit( GetDlgItem(hWnd,IDC_FAR_EDIT), EDITTYPE_FLOAT );
			farspin->SetLimits(-999999.0f, 0.0f, FALSE );
			farspin->SetValue(data.fard,FALSE);
			

			HandleInputs(hWnd);

			return 1;

		case WM_COMMAND:

			switch (LOWORD(wParam)) {

				case IDC_MTLID_BUTT:
				case IDC_NODEID_BUTT:				
				case IDC_MTLCOLOR_BUTT:
				case IDC_USERCOLOR_BUTT:				
					HandleInputs(hWnd);
					break;

				case IDOK:
					if (IsDlgButtonChecked(hWnd,IDC_MTLID_BUTT))
						data.type=IDC_MTLID_BUTT;
					else if (IsDlgButtonChecked(hWnd,IDC_NODEID_BUTT))
						data.type=IDC_NODEID_BUTT;
					else data.type=IDC_ALL_BUTT;

					
					if (IsDlgButtonChecked(hWnd,IDC_EFFECT1))
						data.effect= IDC_EFFECT1;
					else if (IsDlgButtonChecked(hWnd,IDC_EFFECT2))
						data.effect=IDC_EFFECT2;
					else if (IsDlgButtonChecked(hWnd,IDC_EFFECT3))
						data.effect=IDC_EFFECT3;
					else if (IsDlgButtonChecked(hWnd,IDC_EFFECT4))
						data.effect=IDC_EFFECT4;
					else if (IsDlgButtonChecked(hWnd,IDC_EFFECT5))
						data.effect=IDC_EFFECT5;
					else if (IsDlgButtonChecked(hWnd,IDC_EFFECT6))
						data.effect=IDC_EFFECT6;



					data.mtl= mtlspin->GetIVal();
					data.node= nodspin->GetIVal();					
					data.close = closespin->GetFVal();
					data.fard = farspin->GetFVal();

					if (data.fard > data.close)
						{
						float temp;
						temp = data.fard;
						data.fard = data.close;
						data.close = temp;
						}
					data.userange = IsDlgButtonChecked(hWnd,IDC_USERANGE_CHECK);

					EndDialog(hWnd,1);
					break;

				case IDCANCEL:
					EndDialog(hWnd,0);
					break;


			}

			return 1;

		case WM_DESTROY:
			  if (mtlspin) {
				  ReleaseISpinner(mtlspin);
				  mtlspin = NULL;
			  }
			  if (nodspin) {
				  ReleaseISpinner(nodspin);
				  nodspin = NULL;
			  }			  
			  if (farspin) {
				  ReleaseISpinner(farspin);
				  farspin = NULL;
			  }			  
			  if (closespin) {
				  ReleaseISpinner(closespin);
				  closespin = NULL;
			  }			  
			  break;

	}

	return 0;

}

//-----------------------------------------------------------------------------
// *> ControlDlgProc()
//

BOOL CALLBACK ControlDlgProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)	{
     static ImageFilter_Glow *flt = NULL;
     if (message == WM_INITDIALOG) 
        flt = (ImageFilter_Glow *)lParam;
     if (flt) 
        return (flt->Control(hWnd,message,wParam,lParam));
     else
        return(FALSE);
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::ShowControl()

BOOL ImageFilter_Glow::ShowControl(HWND hWnd) {
	InitCustomControls(hInst);
     return (DialogBoxParam(
        hInst,
        MAKEINTRESOURCE(IDD_GLOW_CONTROL),
        hWnd,
        (DLGPROC)ControlDlgProc,
        (LPARAM)this));
}

//-----------------------------------------------------------------------------
// *> AboutCtrlDlgProc()
//

BOOL CALLBACK AboutCtrlDlgProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)	{
	switch (message) {
		case WM_INITDIALOG:
			CenterWindow(hWnd,GetParent(hWnd));
			SetCursor(LoadCursor(NULL,IDC_ARROW));
			return 1;
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDOK:				  
				case IDCANCEL:
					EndDialog(hWnd,1);
					break;
			}
			return 1;
	}
	return 0;
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::ShowAbout()

void ImageFilter_Glow::ShowAbout(HWND hWnd)	{
	DialogBoxParam(
		hInst,
		MAKEINTRESOURCE(IDD_GLOW_ABOUT),
		hWnd,
		(DLGPROC)AboutCtrlDlgProc,
		(LPARAM)this);
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::Render()
//

BOOL ImageFilter_Glow::Render(HWND hWnd) {

	BMM_Color_64	*l64,*line64	= NULL;	
	BOOL			result			= TRUE;
	BOOL			abort			= FALSE;

	BYTE			*mtlbuf			= NULL;
	WORD			*nodbuf			= NULL;
	DWORD			type;
	int				gpix,iy,ix;
	float			*zbuf			= NULL;
// normal buff
	DWORD			*normalbuf			= NULL;
// UV buff
	Point2			*uvbuf			= NULL;
//	WORD			*mask16,*m16    = NULL;
	float fard = 1.0e30f, close = -1.0e30f;
	long ct = 0;
	if	(!srcmap)
		return (FALSE);

//	if	(!mskmap)
//		return (FALSE);

	//-- Prepare Line Buffers ------------------------------------------------
	ix = 0;
	if	((line64 = (BMM_Color_64 *)calloc(srcmap->Width(),sizeof(BMM_Color_64)))==NULL)
		goto done;

	if ( (data.type == IDC_MTLID_BUTT) || (data.effect == IDC_EFFECT2) )
	   {
		mtlbuf = (BYTE *)srcmap->GetChannel(BMM_CHAN_MTL_ID,type);
		if (!mtlbuf)
			goto done;

		} 
	else if ( (data.type == IDC_NODEID_BUTT) || (data.effect == IDC_EFFECT3) )
		{
		nodbuf = (WORD *)srcmap->GetChannel(BMM_CHAN_NODE_ID,type);
		if (!nodbuf)
			goto done;
		}	

	if (data.effect == IDC_EFFECT1)
		{
		zbuf = (float *)srcmap->GetChannel(BMM_CHAN_Z,type);
		if (!zbuf)
				goto done;
		}
	else if (data.effect == IDC_EFFECT4)
		{
		uvbuf = (Point2 *)srcmap->GetChannel(BMM_CHAN_UV,type);
		if (!uvbuf)
				goto done;
		}
	else if ( (data.effect == IDC_EFFECT5) || (data.effect == IDC_EFFECT6) )
		{
		normalbuf = (DWORD *)srcmap->GetChannel(BMM_CHAN_NORMAL,type);
		if (!normalbuf)
				goto done;
		}

  //-- Allocate Mask Line
     
  //  mask16 = (WORD *)calloc(srcmap->Width(),sizeof(WORD));

//zbuffer out
  	if (data.effect == IDC_EFFECT1)
		{
//get distance
		if (!data.userange)
			{
			for (ct=0;ct<(srcmap->Width()*srcmap->Height());ct++)
				{	 
		
			if (data.type == IDC_MTLID_BUTT) 
					{
					if (mtlbuf[ct] == data.mtl) 
						{   
						if ((zbuf[ct]<fard) && (zbuf[ct] != -1.0e29))
							fard = zbuf[ct];
						if (zbuf[ct]>close) 
							close = zbuf[ct];
						}
					}
		//-- Node ID -----------------------------------

				else if (data.type == IDC_NODEID_BUTT) 
					{
					if (nodbuf[ct] == data.node) 
						{
						if ((zbuf[ct]<fard)&& (zbuf[ct] > -1.0e29))
							fard = zbuf[ct];
						if (zbuf[ct]>close) 
							close = zbuf[ct];
	
						}
					}
				else
					{
					if ((zbuf[ct]<fard) && (zbuf[ct] > -1.0e29))
						fard = zbuf[ct];
					if (zbuf[ct]>close) 
						close = zbuf[ct];
					}
				}
			RangeDist = close - fard;
			StartDist = close;
			EndDist = fard;
			}
			else
			{
			RangeDist = data.close-data.fard;
			StartDist = data.close;
			EndDist = data.fard;
			}
		}	


	//------------------------------------------------------------------------
	//-- Process -------------------------------------------------------------

	for (iy = 0; iy < srcmap->Height(); iy++) {

		gpix = iy * srcmap->Width();

		//-- Progress Report
		
		SendMessage(hWnd,FLT_PROGRESS,iy,srcmap->Height()-1);

		//-- Check for	Abort
		
		SendMessage(hWnd,FLT_CHECKABORT,0,(LPARAM)(BOOL	*)&abort);

		if (abort)
			goto done;
		
		//-- Get	line
		
		l64 = line64;
    //    m16 = mask16;

		if (srcmap->GetLinearPixels(0,iy,srcmap->Width(),line64)!=1)
			goto done;
		
		
//		if (mskmap->Get16Gray(0,iy,srcmap->Width(),mask16)!=1) 
//			goto done;
           
        
		
		for ( ix = 0; ix < srcmap->Width();	ix++,l64++)	
			{
		//-- Material ID -------------------------------
		
			if (data.type == IDC_MTLID_BUTT) 
				{
				if (mtlbuf[gpix+ix] == data.mtl) 
					{   
					//process pixel
					switch (data.effect)
						{
						case IDC_EFFECT1 : ProcessZBuf(ix,iy,l64,zbuf[gpix+ix]); break;
						case IDC_EFFECT2 : ProcessMatBuf(ix,iy,l64,mtlbuf[gpix+ix]); break;
						case IDC_EFFECT3 : ProcessNodeBuf(ix,iy,l64,nodbuf[gpix+ix]); break;
						case IDC_EFFECT4 : ProcessUVBuf(ix,iy,l64,uvbuf[gpix+ix]); break;
						case IDC_EFFECT5 : ProcessNormalBuf(ix,iy,l64,normalbuf[gpix+ix]); break;
						case IDC_EFFECT6 : ProcessINormalBuf(ix,iy,l64,normalbuf[gpix+ix]); break;
						}
					}
				}
		//-- Node ID -----------------------------------

			else if (data.type == IDC_NODEID_BUTT) 
				{
				if (nodbuf[gpix+ix] == data.node) 
					{
					//process pixel
					switch (data.effect)
						{
						case IDC_EFFECT1 : ProcessZBuf(ix,iy,l64,zbuf[gpix+ix]); break;
						case IDC_EFFECT2 : ProcessMatBuf(ix,iy,l64,mtlbuf[gpix+ix]); break;
						case IDC_EFFECT3 : ProcessNodeBuf(ix,iy,l64,nodbuf[gpix+ix]); break;
						case IDC_EFFECT4 : ProcessUVBuf(ix,iy,l64,uvbuf[gpix+ix]); break;
						case IDC_EFFECT5 : ProcessNormalBuf(ix,iy,l64,normalbuf[gpix+ix]); break;
						case IDC_EFFECT6 : ProcessINormalBuf(ix,iy,l64,normalbuf[gpix+ix]); break;
						}
					}
				}	
		 //All pixels
			else
				{
					//process pixel
				switch (data.effect)
					{
					case IDC_EFFECT1 : ProcessZBuf(ix,iy,l64,zbuf[gpix+ix]); break;
					case IDC_EFFECT2 : ProcessMatBuf(ix,iy,l64,mtlbuf[gpix+ix]); break;
					case IDC_EFFECT3 : ProcessNodeBuf(ix,iy,l64,nodbuf[gpix+ix]); break;
					case IDC_EFFECT4 : ProcessUVBuf(ix,iy,l64,uvbuf[gpix+ix]); break;
					case IDC_EFFECT5 : ProcessNormalBuf(ix,iy,l64,normalbuf[gpix+ix]); break;
					case IDC_EFFECT6 : ProcessINormalBuf(ix,iy,l64,normalbuf[gpix+ix]); break;
					}
				}
			}
//put back pixels
//	    srcmap->PutPixels(0,iy,srcmap->Width(),line64);
//		mskmap->Put16Gray(0,iy,srcmap->Width(),mask16);
		}
	

	result = TRUE;

	done:	
			
	if (line64)
		free(line64);
//	if (mask16)
//		free(mask16);
		
	return(result);

}

void ImageFilter_Glow::ProcessZBuf(int sx, int sy,BMM_Color_64 *curPix, float zdata)

{
float dist;


//DebugPrint("value %f\n",zdata);

if ( (RangeDist != 0.0f) && (zdata <= StartDist) && (zdata >= EndDist))
	{
	dist = StartDist - zdata;
	dist = dist/RangeDist;

	curPix->r = (unsigned short) (65535.0f*(1.0f-dist));
	curPix->g = (unsigned short) (65535.0f*(1.0f-dist));
	curPix->b = (unsigned short) (65535.0f*(1.0f-dist));
	srcmap->PutPixels(sx,sy,1,curPix);
	}
   else
	{
	curPix->r = 0;
	curPix->g = 0;
	curPix->b = 0;
	srcmap->PutPixels(sx,sy,1,curPix);
	}

}

void ImageFilter_Glow::ProcessNodeBuf(int sx, int sy,BMM_Color_64 *curPix, WORD nodedata)

{


if ( nodedata < 256)
	{
	curPix->r = (unsigned short) (nodedata * 256);
	curPix->g = (unsigned short) (nodedata * 256);
	curPix->b = (unsigned short) (nodedata * 256);
	srcmap->PutPixels(sx,sy,1,curPix);
	}
   else
	{
	curPix->r = 0;
	curPix->g = 0;
	curPix->b = 0;
	srcmap->PutPixels(sx,sy,1,curPix);
	}

}

void ImageFilter_Glow::ProcessMatBuf(int sx, int sy,BMM_Color_64 *curPix, BYTE nodedata)

{


if ( nodedata <= 16)
	{
	curPix->r = (unsigned short) (nodedata * 4096);
	curPix->g = (unsigned short) (nodedata * 4096);
	curPix->b = (unsigned short) (nodedata * 4096);
	srcmap->PutPixels(sx,sy,1,curPix);
	}
   else
	{
	curPix->r = 0;
	curPix->g = 0;
	curPix->b = 0;
	srcmap->PutPixels(sx,sy,1,curPix);
	}

}


void ImageFilter_Glow::ProcessUVBuf(int sx, int sy,BMM_Color_64 *curPix, Point2 nodedata)

{

float x = 0.0f,y = 0.0f;

x = nodedata.x - (int) nodedata.x;
y = nodedata.y - (int) nodedata.y;

if (x<0.0f) x = 1.0f + x;
if (y<0.0f) y = 1.0f + y;

curPix->r = (unsigned short) (x * 65535);
curPix->g = 0;
curPix->b = (unsigned short) (y * 65535);
srcmap->PutPixels(sx,sy,1,curPix);

}

void ImageFilter_Glow::ProcessNormalBuf(int sx, int sy,BMM_Color_64 *curPix, DWORD nodedata)

{

float angle;

Point3 z(0.0f,0.0f,1.0f);
Point3 normal = DeCompressNormal((ULONG)nodedata);


angle = (float) acos(DotProd(z,normal));


if (angle < (PI/2.0f))
	{
	angle = angle/(PI/2.0f);
	curPix->r = (unsigned short) (angle * 65535);
	curPix->g = (unsigned short) (angle * 65535);
	curPix->b = (unsigned short) (angle * 65535);
	srcmap->PutPixels(sx,sy,1,curPix);
	}
   else
	{
	curPix->r = 0;
	curPix->g = 0;
	curPix->b = 0;
	srcmap->PutPixels(sx,sy,1,curPix);
	}

}


void ImageFilter_Glow::ProcessINormalBuf(int sx, int sy,BMM_Color_64 *curPix, DWORD nodedata)

{

float angle;

Point3 z(0.0f,0.0f,1.0f);
Point3 normal = DeCompressNormal((ULONG)nodedata);


angle = (float) acos(DotProd(z,normal));


if (angle < (PI/2.0f))
	{
	angle = (1.0f - angle/(PI/2.0f));
	curPix->r = (unsigned short) (angle * 65535);
	curPix->g = (unsigned short) (angle * 65535);
	curPix->b = (unsigned short) (angle * 65535);
	srcmap->PutPixels(sx,sy,1,curPix);
	}
   else
	{
	curPix->r = 0;
	curPix->g = 0;
	curPix->b = 0;
	srcmap->PutPixels(sx,sy,1,curPix);
	}

}



//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::LoadConfigure()

BOOL ImageFilter_Glow::LoadConfigure ( void *ptr ) {
     GLOWDATA *buf = (GLOWDATA *)ptr;
     if (buf->version == GLOWVERSION) {
        memcpy((void *)&data,ptr,sizeof(GLOWDATA));
        return (TRUE);
     } else
        return (FALSE);
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::SaveConfigure()

BOOL ImageFilter_Glow::SaveConfigure ( void *ptr ) {
     if (ptr) {
        memcpy(ptr,(void *)&data,sizeof(GLOWDATA));
		return (TRUE);
	} else
        return (FALSE);
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::EvaluateConfigure()

DWORD ImageFilter_Glow::EvaluateConfigure ( ) {
	return (sizeof(GLOWDATA));
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::ChannelsRequired()

DWORD ImageFilter_Glow::ChannelsRequired ( ) {

	int effect;

	switch (data.effect)
		{
		case IDC_EFFECT1 : effect = BMM_CHAN_Z; break;
		case IDC_EFFECT2 : effect = BMM_CHAN_MTL_ID; break;
		case IDC_EFFECT3 : effect = BMM_CHAN_NODE_ID; break;
		case IDC_EFFECT4 : effect = BMM_CHAN_UV; break;
		case IDC_EFFECT5 : effect = BMM_CHAN_NORMAL; break;
		case IDC_EFFECT6 : effect = BMM_CHAN_NORMAL; break;

		}

	if (data.type == IDC_MTLID_BUTT )
		return(BMM_CHAN_MTL_ID | effect);
	else if (data.type == IDC_NODEID_BUTT )
		return(BMM_CHAN_NODE_ID | effect);
	else return(effect);


}

//--	EOF: Glow.cpp --------------------------------------------------------
