//-----------------------------------------------------------------------------
// -------------------
// File	....:	Glow.cpp
// -------------------
// Author...:	Gus J	Grubba
// Date	....:	September 1995
// Descr....:	Glow Image Filter
//
// History	.:	Feb, 17 1996 -	Started
//				
//-----------------------------------------------------------------------------
		
//--	Include files

#include <Max.h>
#include <bmmlib.h>
#include <fltlib.h>
#include "Glow.h"
#include "resource.h"

//--	Globals ------------------------------------------------------------------

HINSTANCE hInst = NULL;

static ISpinnerControl	*mtlspin = NULL;
static ISpinnerControl	*nodspin = NULL;
static ISpinnerControl	*minthresholdspin = NULL;
static ISpinnerControl	*maxthresholdspin = NULL;
static ISpinnerControl	*randomspin = NULL;
static IColorSwatch		*colorSwatch = NULL;
COLORREF colorref;

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//--	DLL Declaration

BOOL WINAPI DllMain(HINSTANCE hDLLInst, DWORD fdwReason, LPVOID lpvReserved)	{
	switch (fdwReason) {
		 case	DLL_PROCESS_ATTACH:
				if (hInst)
					return(FALSE);
				hInst = hDLLInst;
				break;
		 case	DLL_PROCESS_DETACH:
				hInst =	NULL;
				break;
		 case	DLL_THREAD_ATTACH:
				break;
		 case	DLL_THREAD_DETACH:
				break;
	}
	return TRUE;
}

TCHAR *GetString(int id)
	{
	static TCHAR buf[256];

	if (hInst)
		return LoadString(hInst, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
	}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Glow	Class	Description

class GLOWClassDesc:public ClassDesc {
	
	public:

		int				IsPublic ( )					{ return	1; }
		void			*Create (BOOL loading=FALSE)	{ return	new ImageFilter_Glow; }
		const	TCHAR	*ClassName ( )					{ return	GetString(IDS_DB_GLOW);	}
		SClass_ID		SuperClassID ( )				{ return	FLT_CLASS_ID; }
		Class_ID		ClassID	( )						{ return	Class_ID(0x28bb03d4, 0x1ea21f99); }
		const	TCHAR	*Category ( )					{ return	GetString(IDS_DB_IMAGE_FILTER); }

};

static GLOWClassDesc GLOWDesc;

//-----------------------------------------------------------------------------
// Interface

DLLEXPORT const TCHAR * LibDescription (	) { 
 	return GetString(IDS_DB_GLOW_FILTER); 
}

DLLEXPORT int	LibNumberClasses ( ) { 
	return 1; 
}

DLLEXPORT ClassDesc	*LibClassDesc(int	i) {
	switch(i) {
		case 0:		return &GLOWDesc;	break;
		default:	return 0;			break;
	}
}

DLLEXPORT ULONG LibVersion (	)	{ 
	return (VERSION_3DSMAX);	
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::ImageFilter_Glow()
//

ImageFilter_Glow::ImageFilter_Glow() {
	data.version = GLOWVERSION;
	data.type = IDC_MTLID_BUTT;
	data.mtl  = 0;
	data.node = 0;
	data.minthreshold = 0.0f;	
	data.maxthreshold = 1.0f;
	data.randomamount = 100;
	data.color.r = 0xFFFF;
	data.color.g = 0xFFFF;
	data.color.b = 0xFFFF;
	data.color.a = 0xFFFF;	
	data.use_replace_color = 1;

}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::HandleInputs()
//

void ImageFilter_Glow::HandleInputs( HWND hWnd ) {
	HWND hDlg;

	BOOL flag = IsDlgButtonChecked(hWnd,IDC_MTLID_BUTT);
	BOOL flag1 = IsDlgButtonChecked(hWnd,IDC_NODEID_BUTT);
	BOOL flag2 = IsDlgButtonChecked(hWnd,IDC_ALL_BUTT);


	if (flag)
		{
		hDlg = GetDlgItem(hWnd,IDC_MTLID_EDIT);
		EnableWindow(hDlg,TRUE);
		hDlg = GetDlgItem(hWnd,IDC_MTLID_SPIN);
		EnableWindow(hDlg,TRUE);


		hDlg = GetDlgItem(hWnd,IDC_NODEID_EDIT);
		EnableWindow(hDlg,FALSE);
		hDlg = GetDlgItem(hWnd,IDC_NODEID_SPIN);
		EnableWindow(hDlg,FALSE);
		}
	else if (flag1)
		{
		hDlg = GetDlgItem(hWnd,IDC_MTLID_EDIT);
		EnableWindow(hDlg,FALSE);
		hDlg = GetDlgItem(hWnd,IDC_MTLID_SPIN);
		EnableWindow(hDlg,FALSE);


		hDlg = GetDlgItem(hWnd,IDC_NODEID_EDIT);
		EnableWindow(hDlg,TRUE);
		hDlg = GetDlgItem(hWnd,IDC_NODEID_SPIN);
		EnableWindow(hDlg,TRUE);
		}
	else
		{
		hDlg = GetDlgItem(hWnd,IDC_MTLID_EDIT);
		EnableWindow(hDlg,FALSE);
		hDlg = GetDlgItem(hWnd,IDC_MTLID_SPIN);
		EnableWindow(hDlg,FALSE);


		hDlg = GetDlgItem(hWnd,IDC_NODEID_EDIT);
		EnableWindow(hDlg,FALSE);
		hDlg = GetDlgItem(hWnd,IDC_NODEID_SPIN);
		EnableWindow(hDlg,FALSE);
		}



	

}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::Control()
//

BOOL ImageFilter_Glow::Control(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)	{

	float temp;

	switch (message) {

		case WM_INITDIALOG:
			CenterWindow(hWnd,GetParent(hWnd));
			SetCursor(LoadCursor(NULL,IDC_ARROW));

			CheckRadioButton(
				hWnd,
				IDC_MTLID_BUTT,
				IDC_ALL_BUTT,
				data.type
			);
			
			CheckDlgButton(hWnd,IDC_USEREPLACE,data.use_replace_color);
						
			colorSwatch = GetIColorSwatch(
				GetDlgItem(hWnd, IDC_COLOR_SWATCH),
				RGB(data.color.r>>8,data.color.g>>8,data.color.b>>8),
				GetString(IDS_DB_GLOW_COLOR));						

			mtlspin	= GetISpinner(GetDlgItem(hWnd, IDC_MTLID_SPIN));
			mtlspin->LinkToEdit( GetDlgItem(hWnd,IDC_MTLID_EDIT), EDITTYPE_INT );
			mtlspin->SetLimits(	1,8, FALSE );
			mtlspin->SetValue(data.mtl,FALSE);

			nodspin	= GetISpinner(GetDlgItem(hWnd, IDC_NODEID_SPIN));
			nodspin->LinkToEdit( GetDlgItem(hWnd,IDC_NODEID_EDIT), EDITTYPE_INT );
			nodspin->SetLimits(	1,65535, FALSE );
			nodspin->SetValue(data.node,FALSE);
			
			minthresholdspin = GetISpinner(GetDlgItem(hWnd, IDC_MINTHRESHOLD_SPIN));
			minthresholdspin->LinkToEdit( GetDlgItem(hWnd,IDC_MINTHRESHOLD_EDIT), EDITTYPE_FLOAT );
			minthresholdspin->SetLimits( 0.0f,1.0f, FALSE );
			minthresholdspin->SetScale( 0.1f);
			minthresholdspin->SetValue(data.minthreshold,FALSE);			

			maxthresholdspin = GetISpinner(GetDlgItem(hWnd, IDC_MAXTHRESHOLD_SPIN));
			maxthresholdspin->LinkToEdit( GetDlgItem(hWnd,IDC_MAXTHRESHOLD_EDIT), EDITTYPE_FLOAT );
			maxthresholdspin->SetLimits( 0.0f,1.0f, FALSE );
			maxthresholdspin->SetScale( 0.1f);
			maxthresholdspin->SetValue(data.maxthreshold,FALSE);			

			randomspin = GetISpinner(GetDlgItem(hWnd, IDC_RANDOM_SPIN));
			randomspin->LinkToEdit( GetDlgItem(hWnd,IDC_RANDOM_EDIT), EDITTYPE_INT );
			randomspin->SetLimits( 0,100, FALSE );
			randomspin->SetValue(data.randomamount,FALSE);			

			HandleInputs(hWnd);

			return 1;

		case WM_COMMAND:

			switch (LOWORD(wParam)) {

				case IDC_MTLID_BUTT:
				case IDC_NODEID_BUTT:				
				case IDC_MTLCOLOR_BUTT:
				case IDC_USERCOLOR_BUTT:				
					HandleInputs(hWnd);
					break;

				case IDOK:
					if (IsDlgButtonChecked(hWnd,IDC_MTLID_BUTT))
						data.type=IDC_MTLID_BUTT;
					else if (IsDlgButtonChecked(hWnd,IDC_NODEID_BUTT))
						data.type=IDC_NODEID_BUTT;
					else data.type=IDC_ALL_BUTT;
					
					data.use_replace_color = IsDlgButtonChecked(hWnd,IDC_USEREPLACE);

					data.mtl= mtlspin->GetIVal();
					data.node= nodspin->GetIVal();					
					data.minthreshold= minthresholdspin->GetFVal();
					data.maxthreshold= maxthresholdspin->GetFVal();
					data.randomamount= randomspin->GetIVal();					

					if (data.minthreshold > data.maxthreshold)
						{
						temp = data.minthreshold;
						data.minthreshold = data.maxthreshold;
						data.maxthreshold = temp;
						}



					colorref = colorSwatch->GetColor();
					data.color.r = GetRValue(colorref)<<8|0xFF;
					data.color.g = GetGValue(colorref)<<8|0xFF;
					data.color.b = GetBValue(colorref)<<8|0xFF;					
					EndDialog(hWnd,1);
					break;

				case IDCANCEL:
					EndDialog(hWnd,0);
					break;


			}

			return 1;

		case WM_DESTROY:
			  if (mtlspin) {
				  ReleaseISpinner(mtlspin);
				  mtlspin = NULL;
			  }
			  if (nodspin) {
				  ReleaseISpinner(nodspin);
				  nodspin = NULL;
			  }			  
			  if (minthresholdspin) {
				  ReleaseISpinner(minthresholdspin);
				  minthresholdspin = NULL;
			  }
			  if (maxthresholdspin) {
				  ReleaseISpinner(maxthresholdspin);
				  maxthresholdspin = NULL;
			  }

			  if (colorSwatch) {
					ReleaseIColorSwatch(colorSwatch);
					colorSwatch = NULL;
			  }			  
			  break;

	}

	return 0;

}

//-----------------------------------------------------------------------------
// *> ControlDlgProc()
//

BOOL CALLBACK ControlDlgProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)	{
     static ImageFilter_Glow *flt = NULL;
     if (message == WM_INITDIALOG) 
        flt = (ImageFilter_Glow *)lParam;
     if (flt) 
        return (flt->Control(hWnd,message,wParam,lParam));
     else
        return(FALSE);
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::ShowControl()

BOOL ImageFilter_Glow::ShowControl(HWND hWnd) {
	InitCustomControls(hInst);
     return (DialogBoxParam(
        hInst,
        MAKEINTRESOURCE(IDD_GLOW_CONTROL),
        hWnd,
        (DLGPROC)ControlDlgProc,
        (LPARAM)this));
}

//-----------------------------------------------------------------------------
// *> AboutCtrlDlgProc()
//

BOOL CALLBACK AboutCtrlDlgProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)	{
	switch (message) {
		case WM_INITDIALOG:
			CenterWindow(hWnd,GetParent(hWnd));
			SetCursor(LoadCursor(NULL,IDC_ARROW));
			return 1;
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDOK:				  
				case IDCANCEL:
					EndDialog(hWnd,1);
					break;
			}
			return 1;
	}
	return 0;
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::ShowAbout()

void ImageFilter_Glow::ShowAbout(HWND hWnd)	{
	DialogBoxParam(
		hInst,
		MAKEINTRESOURCE(IDD_GLOW_ABOUT),
		hWnd,
		(DLGPROC)AboutCtrlDlgProc,
		(LPARAM)this);
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::Render()
//

BOOL ImageFilter_Glow::Render(HWND hWnd) {

	BMM_Color_64	*l64,*line64	= NULL;	
	BOOL			result			= TRUE;
	BOOL			abort			= FALSE;

	BYTE			*mtlbuf			= NULL;
	WORD			*nodbuf			= NULL;
	DWORD			type;
	int				gpix,iy,ix;
//	WORD			*mask16,*m16    = NULL;


	if	(!srcmap)
		return (FALSE);

//	if	(!mskmap)
//		return (FALSE);

	//-- Prepare Line Buffers ------------------------------------------------

	if	((line64 = (BMM_Color_64 *)calloc(srcmap->Width(),sizeof(BMM_Color_64)))==NULL)
		goto done;

	if (data.type == IDC_MTLID_BUTT) 
	   {
		mtlbuf = (BYTE *)srcmap->GetChannel(BMM_CHAN_MTL_ID,type);
		if (!mtlbuf)
			goto done;

		} 
	else if (data.type == IDC_NODEID_BUTT)
		{
		nodbuf = (WORD *)srcmap->GetChannel(BMM_CHAN_NODE_ID,type);
		if (!nodbuf)
			goto done;
		}	

     //-- Allocate Mask Line
     
  //  mask16 = (WORD *)calloc(srcmap->Width(),sizeof(WORD));

	
	//------------------------------------------------------------------------
	//-- Process -------------------------------------------------------------

	for (iy = 0; iy < srcmap->Height(); iy++) {

		gpix = iy * srcmap->Width();

		//-- Progress Report
		
		SendMessage(hWnd,FLT_PROGRESS,iy,srcmap->Height()-1);

		//-- Check for	Abort
		
		SendMessage(hWnd,FLT_CHECKABORT,0,(LPARAM)(BOOL	*)&abort);

		if (abort)
			goto done;
		
		//-- Get	line
		
		l64 = line64;
    //    m16 = mask16;

		if (srcmap->GetLinearPixels(0,iy,srcmap->Width(),line64)!=1)
			goto done;
		
		
//		if (mskmap->Get16Gray(0,iy,srcmap->Width(),mask16)!=1) 
//			goto done;
           
        
		
		for ( ix = 0; ix < srcmap->Width();	ix++,l64++)	
			{
		//-- Material ID -------------------------------
		
			if (data.type == IDC_MTLID_BUTT) 
				{
				if (mtlbuf[gpix+ix] == data.mtl) 
					{   
					//process pixel
					ProcessPixel(ix,iy,l64);
					}
				}
		//-- Node ID -----------------------------------

			else if (data.type == IDC_NODEID_BUTT) 
				{
				if (nodbuf[gpix+ix] == data.node) 
					{
					ProcessPixel(ix,iy,l64);
					}
				}	
		 //All pixels
			else
				{
				ProcessPixel(ix,iy,l64);
				}
			}
//put back pixels
//	    srcmap->PutPixels(0,iy,srcmap->Width(),line64);
//		mskmap->Put16Gray(0,iy,srcmap->Width(),mask16);
		}
	

	result = TRUE;

	done:	
			
	if (line64)
		free(line64);
//	if (mask16)
//		free(mask16);
		
	return(result);

}

void ImageFilter_Glow::ProcessPixel(int sx, int sy,BMM_Color_64 *curPix)

{
float MinThreshold,MaxThreshold;
int cx,cy;
int matrix[4][4];
float distance,a;
int value;
int rd,dif;

MinThreshold =  (data.minthreshold* 65536.0f);
MaxThreshold =  (data.maxthreshold* 65536.0f);

matrix[0][0] =0;
matrix[0][1] =8;
matrix[0][2] =2;
matrix[0][3] =10;

matrix[1][0] =12;
matrix[1][1] =4;
matrix[1][2] =14;
matrix[1][3] =6;

matrix[2][0] =3;
matrix[2][1] =11;
matrix[2][2] =1;
matrix[2][3] =9;

matrix[3][0] =15;
matrix[3][1] =7;
matrix[3][2] =13;
matrix[3][3] =5;

 											 
if ( ((float) curPix->a <= MinThreshold) ||
	 (curPix->a ==0) )


	{
//Nuke Alpha and use solid color
	curPix->a =0;
	if (data.use_replace_color)
		{
		curPix->r = data.color.r;
		curPix->g = data.color.g;
		curPix->b = data.color.b;
		}
	}
else if ( ((float)curPix->a >= MaxThreshold) ||
	      (curPix->a == 0xFFFF) )

	{
//Use opace
	curPix->a =0xFFFF;
	}
else
	{
// figure out percentage
	distance = MaxThreshold - MinThreshold;

	a = (float)curPix->a;
	value = (int)( ( (a-MinThreshold)*16.0) / distance);
	
	cx = sx%4;
	cy = sy%4;

	dif = 0;

	rd = (RAND_MAX-rand())/RAND_MAX*100;
	if ((rd < data.randomamount) && (value !=16) && (value !=0))
		{
		if ( rand() < (RAND_MAX/2) )
				dif = -1;
			  else
				dif = 1;
		}

	if (matrix[cx][cy] < (value+dif))
		{
		curPix->a =0xFFFF;
		}
	else
		{
		if (data.use_replace_color)
			{
			curPix->r = data.color.r;
			curPix->g = data.color.g;
			curPix->b = data.color.b;
			}
		curPix->a =0;
		}
	}


	
srcmap->PutPixels(sx,sy,1,curPix);
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::LoadConfigure()

BOOL ImageFilter_Glow::LoadConfigure ( void *ptr ) {
     GLOWDATA *buf = (GLOWDATA *)ptr;
     if (buf->version == GLOWVERSION) {
        memcpy((void *)&data,ptr,sizeof(GLOWDATA));
        return (TRUE);
     } else
        return (FALSE);
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::SaveConfigure()

BOOL ImageFilter_Glow::SaveConfigure ( void *ptr ) {
     if (ptr) {
        memcpy(ptr,(void *)&data,sizeof(GLOWDATA));
		return (TRUE);
	} else
        return (FALSE);
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::EvaluateConfigure()

DWORD ImageFilter_Glow::EvaluateConfigure ( ) {
	return (sizeof(GLOWDATA));
}

//-----------------------------------------------------------------------------
// #> ImageFilter_Glow::ChannelsRequired()

DWORD ImageFilter_Glow::ChannelsRequired ( ) {

	if (data.type == IDC_MTLID_BUTT)
		return(BMM_CHAN_MTL_ID);
	else
		return(BMM_CHAN_NODE_ID);

}

//--	EOF: Glow.cpp --------------------------------------------------------
