#include "SkinMSX.h"

def_struct_primitive( getBoneBindTM,skinOps2, "getBoneBindTM" );
def_struct_primitive( getMeshBindTM,skinOps2, "getMeshBindTM" );

def_struct_primitive( setBoneBindTM,skinOps2, "setBoneBindTM" );
def_struct_primitive( setMeshBindTM,skinOps2, "setMeshBindTM" );



Value*
getBoneBindTM_cf(Value** arg_list, int count)
{
	check_arg_count(getBoneBindTM, 2, count);
	Modifier *mod = arg_list[0]->to_modifier();
	ISkin *skin = (ISkin *) mod->GetInterface(I_SKIN);

	Matrix3 tm(1);

	if (mod)
		{
		INode *node;
		node =  arg_list[1]->to_node();
		if (node)
			{
			
			skin->GetBoneInitTM(node, tm );
			}
		}

	Matrix3Value *tmv = new Matrix3Value(tm);


	return tmv;
}



Value*
getMeshBindTM_cf(Value** arg_list, int count)
{
	check_arg_count(getMeshBindTM, 2, count);
	Modifier *mod = arg_list[0]->to_modifier();
	ISkin *skin = (ISkin *) mod->GetInterface(I_SKIN);

	Matrix3 tm(1);

	if (mod)
		{
		INode *node;
		node =  arg_list[1]->to_node();
		if (node)
			{
			
			skin->GetSkinInitTM(node, tm );
			}
		}

	Matrix3Value *tmv = new Matrix3Value(tm);


	return tmv;
}


Value*
setBoneBindTM_cf(Value** arg_list, int count)
{
	check_arg_count(getBoneBindTM, 3, count);
	Modifier *mod = arg_list[0]->to_modifier();
	ISkinImportData *skin = (ISkinImportData *) mod->GetInterface(I_SKINIMPORTDATA);

	Matrix3 tm(1);

	if (mod)
		{
		INode *node;
		node =  arg_list[1]->to_node();
		tm = arg_list[2]->to_matrix3();
		if (node)
			{
			
			skin->SetBoneTm(node, tm,tm );
			}
		}

	return &ok;
}



Value*
setMeshBindTM_cf(Value** arg_list, int count)
{
	check_arg_count(getMeshBindTM, 3, count);
	Modifier *mod = arg_list[0]->to_modifier();
	ISkinImportData *skin = (ISkinImportData *) mod->GetInterface(I_SKINIMPORTDATA);

	Matrix3 tm(1);

	if (mod)
		{
		INode *node;
		node =  arg_list[1]->to_node();
		if (node)
			{
			tm = arg_list[2]->to_matrix3();			
			skin->SetSkinTm(node, tm,tm );
			}
		}



	return &ok;
}


/*===========================================================================*\
 |	MAXScript Plugin Initialization
\*===========================================================================*/

__declspec( dllexport ) void
LibInit() { 
}

